/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.issue;

import aptis.plugins.common.AOConverter;
import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldProvider;
import aptis.plugins.common.HtmlFormatter;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.common.AttachmentManager;
import aptis.plugins.shareYourJira.common.CommentManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplateManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditShareLinkServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final ActiveObjects activeObjects;
    private final FieldProvider fieldProvider;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final CommentManager commentManager;
    private final AttachmentManager attachmentManager;

    public EditShareLinkServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, ActiveObjects activeObjects, PluginLicenseManager pluginLicenseManager, UserManager userManager) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.activeObjects = activeObjects;
        this.pluginLicenseManager = pluginLicenseManager;
        this.fieldProvider = new FieldProvider();
        this.userManager = userManager;
        this.commentManager = new CommentManager(i18nResolver);
        this.attachmentManager = new AttachmentManager(i18nResolver);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            String id;
            String sendMail;
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            boolean resendMail = false;
            String string = sendMail = request.getParameter("sendMail") != null ? request.getParameter("sendMail") : "0";
            if (sendMail.equals("1")) {
                resendMail = true;
            }
            if ((id = request.getParameter("id")) == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"id"}));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            IssueShare issueShare = issueShareManager.findIssueShareById(Integer.valueOf(id));
            if (issueShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(id)}));
            }
            if (!this.userManager.isSystemAdmin(userProfile.getUserKey()) && !userProfile.getUserKey().getStringValue().equals(issueShare.getToken().getUserKey())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
            }
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(issueShare.getIssueId()));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(issueShare.getIssueId())}));
            }
            FieldProvider fieldProvider = new FieldProvider();
            List<Field> allFields = fieldProvider.getAllFieldsForIssueShare(this.i18nResolver);
            String fieldIds = allFields.stream().map(field -> field.getId()).collect(Collectors.joining(","));
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            context.put("fieldIds", fieldIds);
            context.put("ShareTemplatesOfUser", shareTemplateManager.getAllShareTemplatesCreatedByUser(user));
            context.put("resendMail", resendMail);
            context.put("title", this.i18nResolver.getText("aptis-sjy-edit-issue-share-link-title"));
            context.put("allFields", allFields);
            context.put("displayingFields", displayFieldManager.getListOfDisplayFieldIds(issueShare));
            context.put("issue", issue);
            context.put("issueShareId", id);
            context.put("validPeriodFromChecked", issueShare.getValidPeriodFrom() != null);
            context.put("validPeriodFrom", issueShare.getValidPeriodFrom() == null ? HtmlFormatter.toHtmlDate(new Date()) : HtmlFormatter.toHtmlDate(issueShare.getValidPeriodFrom()));
            context.put("validPeriodToChecked", issueShare.getValidPeriodTo() != null);
            context.put("validPeriodTo", issueShare.getValidPeriodTo() == null ? HtmlFormatter.toHtmlDate(new Date()) : HtmlFormatter.toHtmlDate(issueShare.getValidPeriodTo()));
            context.put("passwordChecked", issueShare.getPasswordHash() != null);
            context.put("password", issueShare.getPasswordHash() != null ? "PASSWORD_PLACEHOLDER" : "");
            context.put("ipsLockChecked", issueShare.getIPsLock() != null);
            context.put("ipsLock", issueShare.getIPsLock());
            context.put("note", issueShare.getNote());
            context.put("onlyLoggedInUserChecked", issueShare.getOnlyLoggedInUser());
            context.put("user", user);
            context.put("commentManager", this.commentManager);
            context.put("commentVisibilityOptions", AOConverter.convertToStringArray(issueShare.getCommentVisibilityString()));
            context.put("isDefaultSMTPMailServerDefined", ComponentAccessor.getMailServerManager().isDefaultSMTPMailServerDefined());
            context.put("attachmentVisibilityOptions", AOConverter.convertToStringArray(issueShare.getAttachmentVisibilityString()));
            context.put("attachmentManager", this.attachmentManager);
            context.put("localesJsonHtml", this.getLocales().toString());
            this.templateRenderer.render("templates/issue/shareLinkDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    protected JsonObject getLocales() {
        JsonObject locales = new JsonObject();
        locales.addProperty("mailSubject", this.i18nResolver.getText("jira-share-plugin.email.issue.subject"));
        return locales;
    }
}

