/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.issue;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldProvider;
import aptis.plugins.common.HtmlFormatter;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.common.AttachmentManager;
import aptis.plugins.shareYourJira.common.CommentManager;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplateManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CreateShareLinkServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final CommentManager commentManager;
    private final AttachmentManager attachmentManager;
    private final ActiveObjects activeObjects;
    private final ProjectSettingsManager projectSettingsManager;

    public CreateShareLinkServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, UserManager userManager, ActiveObjects activeObjects) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.commentManager = new CommentManager(i18nResolver);
        this.attachmentManager = new AttachmentManager(i18nResolver);
        this.activeObjects = activeObjects;
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            String issueId = request.getParameter("issueId");
            if (issueId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"issueId"}));
            }
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(Long.parseLong(issueId)));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{issueId}));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            ProjectSetting projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            if (!projectPermissionManager.isUserInProjectRole(user, issue.getProjectObject(), ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSettings))) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-share-for-project-not-allowed"));
            }
            FieldProvider fieldProvider = new FieldProvider();
            List<Field> allFields = fieldProvider.getAllFieldsForIssueShare(this.i18nResolver);
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            String fieldIds = allFields.stream().map(field -> field.getId()).collect(Collectors.joining(","));
            context.put("fieldIds", fieldIds);
            context.put("ShareTemplatesOfUser", shareTemplateManager.getAllShareTemplatesCreatedByUser(user));
            context.put("title", this.i18nResolver.getText("aptis-sjy-create-issue-share-link-title"));
            context.put("allFields", allFields);
            context.put("displayingFields", DisplayFieldManager.getDefaultDisplayingIssueFieldIds());
            context.put("issue", issue);
            context.put("validPeriodFromChecked", false);
            context.put("validPeriodFrom", HtmlFormatter.toHtmlDate(new Date()));
            context.put("validPeriodToChecked", false);
            context.put("validPeriodTo", HtmlFormatter.toHtmlDate(new Date()));
            context.put("passwordChecked", false);
            context.put("password", "");
            context.put("ipsLockChecked", false);
            context.put("ipsLock", "");
            context.put("note", "");
            context.put("onlyLoggedInUserChecked", false);
            context.put("attachmentVisibilityOptions", new ArrayList());
            context.put("isDefaultSMTPMailServerDefined", ComponentAccessor.getMailServerManager().isDefaultSMTPMailServerDefined());
            context.put("user", user);
            context.put("commentManager", this.commentManager);
            context.put("commentVisibilityOptions", new ArrayList());
            context.put("attachmentManager", this.attachmentManager);
            context.put("localesJsonHtml", this.getLocales().toString());
            this.templateRenderer.render("templates/issue/shareLinkDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    protected JsonObject getLocales() {
        JsonObject locales = new JsonObject();
        locales.addProperty("mailSubject", this.i18nResolver.getText("jira-share-plugin.email.issue.subject"));
        return locales;
    }
}

