/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.issue;

import aptis.plugins.common.AOConverter;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.common.AttachmentManager;
import aptis.plugins.shareYourJira.common.ShowShareBaseValidator;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttachmentProviderServlet
extends HttpServlet {
    private final PluginLicenseManager pluginLicenseManager;
    private final I18nResolver i18nResolver;
    private final IssueShareManager issueShareManager;
    private final PermissionManager permissionManager;
    private final AttachmentManager attachmentManager;
    private final ProjectSettingsManager projectSettingsManager;

    public AttachmentProviderServlet(PluginLicenseManager pluginLicenseManager, I18nResolver i18nResolver, ActiveObjects activeObjects, PermissionManager permissionManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.i18nResolver = i18nResolver;
        TokenManager tokenManager = new TokenManager(activeObjects);
        this.issueShareManager = new IssueShareManager(activeObjects, tokenManager, new DisplayFieldManager(activeObjects));
        this.permissionManager = permissionManager;
        this.attachmentManager = new AttachmentManager(i18nResolver);
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            if (request.getParameter("shareId") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"shareId"}));
            }
            if (request.getParameter("token") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"token"}));
            }
            if (request.getParameter("attachmentId") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"attachmentId"}));
            }
            int shareId = Integer.parseInt(request.getParameter("shareId"));
            String givenToken = request.getParameter("token");
            Long attachmentId = Long.parseLong(request.getParameter("attachmentId"));
            IssueShare issueShare = this.issueShareManager.findIssueShareById(shareId);
            if (issueShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            Attachment attachment = this.attachmentManager.getAttachmentById(attachmentId);
            if (attachment == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            List<String> attachmentVisibilityOptions = AOConverter.convertToStringArray(issueShare.getAttachmentVisibilityString());
            if (!this.attachmentManager.isVisible(attachment, attachmentVisibilityOptions)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ShowShareBaseValidator showShareBaseValidator = new ShowShareBaseValidator();
            if (!showShareBaseValidator.isShareItemValidForCall(issueShare, request)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            if (!givenToken.equals(issueShare.getToken().getToken())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(issueShare.getIssueId()));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ApplicationUser userFromToken = ComponentAccessor.getUserManager().getUserByKey(issueShare.getToken().getUserKey());
            if (userFromToken == null || !userFromToken.isActive()) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ProjectSetting projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            if (!projectPermissionManager.isUserInProjectRole(userFromToken, issue.getProjectObject(), ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSettings))) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, userFromToken)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            this.attachmentManager.writeAttachmentToHttpServletResponse(response, attachment);
        }
        catch (FileNotFoundException exception) {
            response.setStatus(404);
        }
        catch (Exception exception) {
            response.setStatus(500);
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(exception.getMessage());
        }
    }
}

