/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.history;

import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;

public class ShareHistoryManager {
    private final ActiveObjects activeObjects;

    public ShareHistoryManager(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void addIssueCreated(long issueId, int shareId, String currentShareSummary, ApplicationUser user) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.CREATED, currentShareSummary, user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addIssueChanged(long issueId, int shareId, String currentShareSummary, ApplicationUser user) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.CHANGED, currentShareSummary, user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addIssueCalled(long issueId, int shareId, ApplicationUser user) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.CALLED, "", user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addIssueCalled(long issueId, int shareId, String ip) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.CALLED, "", "", ip, ip);
    }

    public void addIssueDeleted(long issueId, int shareId, ApplicationUser user) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.DELETED, "", user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addFilterCreated(long filterId, int shareId, String currentShareSummary, ApplicationUser user) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.CREATED, currentShareSummary, user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addFilterChanged(long filterId, int shareId, String currentShareSummary, ApplicationUser user) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.CHANGED, currentShareSummary, user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addFilterCalled(long filterId, int shareId, ApplicationUser user) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.CALLED, "", user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addFilterCalled(long filterId, int shareId, String ip) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.CALLED, "", "", ip, ip);
    }

    public void addFilterDeleted(long filterId, int shareId, ApplicationUser user) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.DELETED, "", user.getKey(), this.getUserDisplayName(user), "");
    }

    public void addIssueShared(long issueId, int shareId, String currentShareSummary, ApplicationUser user, String recipients) {
        this.add(issueId, ShareHistoryItem.SharedItemType.ISSUE, shareId, ShareHistoryItem.HistoryType.EMAIL, currentShareSummary, user.getKey(), recipients, "");
    }

    public void addFilterShared(long filterId, int shareId, String currentShareSummary, ApplicationUser user, String recipients) {
        this.add(filterId, ShareHistoryItem.SharedItemType.FILTER, shareId, ShareHistoryItem.HistoryType.EMAIL, currentShareSummary, user.getKey(), recipients, "");
    }

    private String getUserDisplayName(ApplicationUser user) {
        return user.getDisplayName() + " (" + user.getKey() + ")";
    }

    private void add(long sharedItemId, ShareHistoryItem.SharedItemType sharedItemType, int shareId, ShareHistoryItem.HistoryType historyType, String currentShareSummary, String userKey, String displayName, String ip) {
        ShareHistoryItem shareHistoryItem = (ShareHistoryItem)this.activeObjects.create(ShareHistoryItem.class, new DBParam[]{new DBParam("SHARED_ITEM_ID", (Object)sharedItemId), new DBParam("SHARED_ITEM_TYPE", (Object)sharedItemType), new DBParam("TIME", (Object)new Date()), new DBParam("SHARE_ID", (Object)shareId), new DBParam("HISTORY_TYPE", (Object)historyType), new DBParam("CURRENT_SHARE_SUMMARY", (Object)StringUtils.abbreviate((String)currentShareSummary, (int)255)), new DBParam("USER_KEY", (Object)userKey), new DBParam("DISPLAY_NAME", (Object)displayName), new DBParam("IP", (Object)ip)});
        shareHistoryItem.save();
    }

    public List<ShareHistoryItem> getAllByShareId(int shareId, ShareHistoryItem.SharedItemType sharedItemType) {
        ArrayList<ShareHistoryItem> result = new ArrayList<ShareHistoryItem>();
        ShareHistoryItem[] dataResult = (ShareHistoryItem[])this.activeObjects.find(ShareHistoryItem.class, Query.select().where("SHARE_ID = ? AND SHARED_ITEM_TYPE = ?", new Object[]{shareId, sharedItemType}));
        if (dataResult.length > 0) {
            result.addAll(Arrays.asList(dataResult));
        }
        return result;
    }

    public int getCountCallsByShareId(int shareId, ShareHistoryItem.SharedItemType sharedItemType) {
        return this.activeObjects.count(ShareHistoryItem.class, Query.select().where("SHARE_ID = ? AND HISTORY_TYPE = ? AND SHARED_ITEM_TYPE = ?", new Object[]{shareId, ShareHistoryItem.HistoryType.CALLED, sharedItemType}));
    }

    public Date getCreatedDateByShareId(int shareId, ShareHistoryItem.SharedItemType sharedItemType) {
        ShareHistoryItem[] shareHistoryItems = (ShareHistoryItem[])this.activeObjects.find(ShareHistoryItem.class, Query.select().where("SHARE_ID = ? AND HISTORY_TYPE = ? AND SHARED_ITEM_TYPE = ?", new Object[]{shareId, ShareHistoryItem.HistoryType.CREATED, sharedItemType}).limit(1));
        return shareHistoryItems.length == 1 ? shareHistoryItems[0].getTime() : new Date();
    }

    @Nullable
    public ApplicationUser getShareCreatorByShareId(int shareId, ShareHistoryItem.SharedItemType sharedItemType) {
        ShareHistoryItem[] shareHistoryItems = (ShareHistoryItem[])this.activeObjects.find(ShareHistoryItem.class, Query.select().where("SHARE_ID = ? AND HISTORY_TYPE = ? AND SHARED_ITEM_TYPE = ?", new Object[]{shareId, ShareHistoryItem.HistoryType.CREATED, sharedItemType}).limit(1));
        if (shareHistoryItems.length == 0) {
            return null;
        }
        return ComponentAccessor.getUserManager().getUserByKey(shareHistoryItems[0].getUserKey());
    }

    public String getShareCreatorDisplayNameByShareId(int shareId, ShareHistoryItem.SharedItemType sharedItemType) {
        ShareHistoryItem[] shareHistoryItems = (ShareHistoryItem[])this.activeObjects.find(ShareHistoryItem.class, Query.select().where("SHARE_ID = ? AND HISTORY_TYPE = ? AND SHARED_ITEM_TYPE = ?", new Object[]{shareId, ShareHistoryItem.HistoryType.CREATED, sharedItemType}).limit(1));
        return shareHistoryItems.length == 1 ? shareHistoryItems[0].getDisplayName() : "unknown";
    }
}

