/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.history;

import aptis.plugins.common.FieldProvider;
import aptis.plugins.shareYourJira.common.AbstractBaseFieldsRequest;
import aptis.plugins.shareYourJira.filter.CreateShareLinkRequest;
import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import aptis.plugins.shareYourJira.sharedContainer.ShareItem;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ShareHistoryLogItemFormatter {
    public String getShareSummaryForActiveStatus(I18nHelper i18nHelper, ShareItem shareItem) {
        ArrayList<String> changes = new ArrayList<String>();
        String shareSummaryForActiveStatus = this.getShareSummaryForActiveStatus(i18nHelper, shareItem.isActive());
        if (shareSummaryForActiveStatus != null && !shareSummaryForActiveStatus.equals("")) {
            changes.add(shareSummaryForActiveStatus);
        }
        return changes.size() == 0 ? "" : StringUtils.join(changes, ", ");
    }

    public String getShareSummaryForIssue(I18nHelper i18nHelper, I18nResolver i18nResolver, DateTimeFormatterFactory dateTimeFormatterFactory, aptis.plugins.shareYourJira.issue.CreateShareLinkRequest changeRequest) {
        List<String> baseChanges;
        ArrayList<String> changes = new ArrayList<String>();
        String shareSummaryForDisplayFields = this.getShareSummaryForDisplayFields(i18nResolver, changeRequest.getDisplayingFields());
        if (shareSummaryForDisplayFields != null && !shareSummaryForDisplayFields.equals("")) {
            changes.add(shareSummaryForDisplayFields);
        }
        if ((baseChanges = this.getBaseChanges(i18nHelper, dateTimeFormatterFactory, changeRequest)).size() > 0) {
            changes.addAll(baseChanges);
        }
        return changes.size() == 0 ? "" : StringUtils.join(changes, ", ");
    }

    public String getShareSummaryForFilter(I18nHelper i18nHelper, I18nResolver i18nResolver, DateTimeFormatterFactory dateTimeFormatterFactory, CreateShareLinkRequest changeRequest) {
        List<String> baseChanges;
        ArrayList<String> changes = new ArrayList<String>();
        String shareSummaryForDisplayFields = this.getShareSummaryForDisplayFields(i18nResolver, changeRequest.getDisplayingFields());
        if (shareSummaryForDisplayFields != null && !shareSummaryForDisplayFields.equals("")) {
            changes.add(shareSummaryForDisplayFields);
        }
        if ((baseChanges = this.getBaseChanges(i18nHelper, dateTimeFormatterFactory, changeRequest)).size() > 0) {
            changes.addAll(baseChanges);
        }
        return changes.size() == 0 ? "" : StringUtils.join(changes, "; ");
    }

    private List<String> getBaseChanges(I18nHelper i18nHelper, DateTimeFormatterFactory dateTimeFormatterFactory, AbstractBaseFieldsRequest changeRequest) {
        String shareSummaryForOnlyLoggedInUser;
        String shareSummaryForNote;
        String shareSummaryForIPsLock;
        String shareSummaryForPassword;
        String shareSummaryForValidPeriodTo;
        String shareSummaryForValidPeriodFrom;
        ArrayList<String> changes = new ArrayList<String>();
        String shareSummaryForActiveStatus = this.getShareSummaryForActiveStatus(i18nHelper, changeRequest.getActive());
        if (shareSummaryForActiveStatus != null && !shareSummaryForActiveStatus.equals("")) {
            changes.add(shareSummaryForActiveStatus);
        }
        if ((shareSummaryForValidPeriodFrom = this.getShareSummaryForValidPeriodFrom(i18nHelper, dateTimeFormatterFactory, changeRequest.getValidPeriodFrom())) != null && !shareSummaryForValidPeriodFrom.equals("")) {
            changes.add(shareSummaryForValidPeriodFrom);
        }
        if ((shareSummaryForValidPeriodTo = this.getShareSummaryForValidPeriodTo(i18nHelper, dateTimeFormatterFactory, changeRequest.getValidPeriodTo())) != null && !shareSummaryForValidPeriodTo.equals("")) {
            changes.add(shareSummaryForValidPeriodTo);
        }
        if ((shareSummaryForPassword = this.getShareSummaryForPassword(i18nHelper, changeRequest.getPassword())) != null && !shareSummaryForPassword.equals("") && !shareSummaryForPassword.equals("PASSWORD_PLACEHOLDER")) {
            changes.add(shareSummaryForPassword);
        }
        if ((shareSummaryForIPsLock = this.getShareSummaryForIPsLock(i18nHelper, changeRequest.getIPsLock())) != null && !shareSummaryForIPsLock.equals("")) {
            changes.add(shareSummaryForIPsLock);
        }
        if ((shareSummaryForNote = this.getShareSummaryForNote(i18nHelper, changeRequest.getNote())) != null && !shareSummaryForNote.equals("")) {
            changes.add(shareSummaryForNote);
        }
        if ((shareSummaryForOnlyLoggedInUser = this.getShareSummaryForOnlyLoggedInUser(i18nHelper, changeRequest.getOnlyLoggedInUser())) != null && !shareSummaryForOnlyLoggedInUser.equals("")) {
            changes.add(shareSummaryForOnlyLoggedInUser);
        }
        return changes;
    }

    private String getShareSummaryForDisplayFields(I18nResolver i18nResolver, @Nullable List<String> displayFieldIds) {
        if (displayFieldIds == null || displayFieldIds.size() == 0) {
            return "";
        }
        String fieldsAsString = "";
        List<Field> fields = new FieldProvider().getFieldsByFieldIds(displayFieldIds, i18nResolver);
        for (Field field : fields) {
            if (!fieldsAsString.equals("")) {
                fieldsAsString = fieldsAsString + ", ";
            }
            fieldsAsString = fieldsAsString + field.getName();
        }
        return i18nResolver.getText("aptis-sjy-fields-to-display") + ": " + fieldsAsString;
    }

    private String getShareSummaryForActiveStatus(I18nHelper i18nHelper, @Nullable Boolean active) {
        if (active == null) {
            return "";
        }
        String activeStatusAsString = i18nHelper.getText("admin.common.words.active") + ": ";
        activeStatusAsString = active.equals(true) ? activeStatusAsString + i18nHelper.getText("common.words.yes") : activeStatusAsString + i18nHelper.getText("common.words.no");
        return activeStatusAsString;
    }

    private String getShareSummaryForValidPeriodFrom(I18nHelper i18nHelper, DateTimeFormatterFactory dateTimeFormatterFactory, @Nullable Date validPeriodFrom) {
        if (validPeriodFrom == null) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withLocale(i18nHelper.getLocale());
        return i18nHelper.getText("aptis-sjy-validity-period") + " " + i18nHelper.getText("aptis-sjy-validity-period-from") + ": " + dateTimeFormatter.format(validPeriodFrom);
    }

    private String getShareSummaryForValidPeriodTo(I18nHelper i18nHelper, DateTimeFormatterFactory dateTimeFormatterFactory, @Nullable Date validPeriodTo) {
        if (validPeriodTo == null) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withLocale(i18nHelper.getLocale());
        return i18nHelper.getText("aptis-sjy-validity-period") + " " + i18nHelper.getText("aptis-sjy-validity-period-to") + ": " + dateTimeFormatter.format(validPeriodTo);
    }

    private String getShareSummaryForPassword(I18nHelper i18nHelper, @Nullable String passwordHash) {
        if (passwordHash == null) {
            return "";
        }
        return i18nHelper.getText("aptis-sjy-password-changed");
    }

    private String getShareSummaryForIPsLock(I18nHelper i18nHelper, @Nullable String ipsLock) {
        if (ipsLock == null) {
            return "";
        }
        return i18nHelper.getText("aptis-sjy-ips-lock-changed");
    }

    private String getShareSummaryForNote(I18nHelper i18nHelper, @Nullable String note) {
        if (note == null) {
            return "";
        }
        return i18nHelper.getText("aptis-sjy-note-changed");
    }

    private String getShareSummaryForOnlyLoggedInUser(I18nHelper i18nHelper, @Nullable Boolean onlyLoggedInUser) {
        if (onlyLoggedInUser == null) {
            return "";
        }
        String activeStatusAsString = i18nHelper.getText("aptis-sjy-only-logged-in-users") + ": ";
        activeStatusAsString = onlyLoggedInUser != false ? activeStatusAsString + i18nHelper.getText("common.words.yes") : activeStatusAsString + i18nHelper.getText("common.words.no");
        return activeStatusAsString;
    }

    public String getShareSummaryForEMailSent(I18nHelper i18nHelper, List<String> eMailAdresses, String message) {
        return eMailAdresses.toString() + " " + i18nHelper.getText("aptis-syj-email-message") + ": " + message;
    }

    public String getDisplayActionText(ShareHistoryItem shareHistoryItem, I18nResolver i18nResolver) {
        switch (shareHistoryItem.getHistoryType()) {
            case CREATED: {
                return i18nResolver.getText("aptis-sjy-history-share-created", new Serializable[]{shareHistoryItem.getDisplayName()});
            }
            case CHANGED: {
                return i18nResolver.getText("aptis-sjy-history-share-changed", new Serializable[]{shareHistoryItem.getDisplayName()});
            }
            case CALLED: {
                return i18nResolver.getText("aptis-sjy-history-share-called", new Serializable[]{shareHistoryItem.getDisplayName()});
            }
            case DELETED: {
                return i18nResolver.getText("aptis-sjy-history-share-deleted", new Serializable[]{shareHistoryItem.getDisplayName()});
            }
            case EMAIL: {
                return i18nResolver.getText("aptis-syj-history-share-emailed", new Serializable[]{shareHistoryItem.getDisplayName()});
            }
        }
        return "";
    }
}

