/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.history;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import aptis.plugins.shareYourJira.history.ShareHistoryLogItemFormatter;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractShareHistoryServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final ShareHistoryManager shareHistoryManager;
    protected final UserManager userManager;
    protected final ActiveObjects activeObjects;
    protected final ShareHistoryLogItemFormatter shareHistoryLogItemFormatter;

    public AbstractShareHistoryServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, ActiveObjects activeObjects, DateTimeFormatterFactory dateTimeFormatterFactory, UserManager userManager) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.shareHistoryManager = new ShareHistoryManager(activeObjects);
        this.userManager = userManager;
        this.activeObjects = activeObjects;
        this.shareHistoryLogItemFormatter = new ShareHistoryLogItemFormatter();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            String shareId = request.getParameter("shareId");
            if (shareId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"shareId"}));
            }
            if (!this.hasPermission(jiraAuthenticationContext.getUser(), Integer.valueOf(shareId))) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
            }
            context.put("shareHistoryItems", this.shareHistoryManager.getAllByShareId(Integer.valueOf(shareId), this.getSharedItemType()));
            context.put("servlet", this);
            this.templateRenderer.render("templates/history/shareHistoryDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    public abstract boolean hasPermission(ApplicationUser var1, int var2);

    public abstract ShareHistoryItem.SharedItemType getSharedItemType();

    public String getTime(ShareHistoryItem shareHistoryItem) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        return dateTimeFormatter.format(shareHistoryItem.getTime());
    }

    public long getTimeSort(ShareHistoryItem shareHistoryItem) {
        return shareHistoryItem.getTime().getTime();
    }

    public String getDisplayActionText(ShareHistoryItem shareHistoryItem) {
        return this.shareHistoryLogItemFormatter.getDisplayActionText(shareHistoryItem, this.i18nResolver);
    }
}

