/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSortValueProvider {
    private Map<String, CustomField> idType = new HashMap<String, CustomField>();

    TableSortValueProvider(List<String> ids, List<CustomField> customFields) {
        for (CustomField cF : customFields) {
            this.idType.put(cF.getId(), cF);
        }
    }

    public String getSortValue(String id, Issue issue) {
        switch (id) {
            case "created": {
                return this.getTimestampSortValue(issue.getCreated()).toString();
            }
            case "updated": {
                return this.getTimestampSortValue(issue.getUpdated()).toString();
            }
            case "resolutiondate": {
                return this.getTimestampSortValue(issue.getResolutionDate()).toString();
            }
            case "duedate": {
                return this.getTimestampSortValue(issue.getDueDate()).toString();
            }
            case "priority": {
                Priority issuePriority = issue.getPriority();
                if (issuePriority == null) {
                    return "";
                }
                return issue.getPriority().getSequence().toString();
            }
        }
        if (this.isCustomFieldTimestamp(id)) {
            return this.getTimestampSortValue(this.getCustomFieldTimestamp(id, issue)).toString();
        }
        if (this.isCustomFieldNumber(id)) {
            return this.getNumberSortValue(this.getCustomFieldNumber(id, issue)).toString();
        }
        return null;
    }

    public Long getTimestampSortValue(Timestamp timestamp) {
        if (timestamp == null) {
            timestamp = new Timestamp(0L);
        }
        return timestamp.getTime();
    }

    public boolean isCustomFieldTimestamp(String id) {
        CustomFieldTypeModuleDescriptor descriptor;
        AbstractSingleFieldType abstractSingleFieldType;
        String object;
        String string = object = this.idType.get(id) != null ? this.idType.get(id).getCustomFieldType() : "";
        return object instanceof AbstractSingleFieldType && (abstractSingleFieldType = (AbstractSingleFieldType)object).getDescriptor() != null && (descriptor = abstractSingleFieldType.getDescriptor()).getModuleClass() != null && (descriptor.getModuleClass().getName().equals("com.atlassian.jira.issue.customfields.impl.DateCFType") || descriptor.getModuleClass().getName().equals("com.atlassian.jira.issue.customfields.impl.DateTimeCFType"));
    }

    public Timestamp getCustomFieldTimestamp(String id, Issue issue) {
        if (issue.getCustomFieldValue(this.idType.get(id)) instanceof Timestamp) {
            return (Timestamp)issue.getCustomFieldValue(this.idType.get(id));
        }
        return new Timestamp(0L);
    }

    public Double getNumberSortValue(Double number) {
        if (number == null) {
            number = 0.0;
        }
        return number;
    }

    public boolean isCustomFieldNumber(String id) {
        CustomFieldTypeModuleDescriptor descriptor;
        AbstractSingleFieldType abstractSingleFieldType;
        String object;
        String string = object = this.idType.get(id) != null ? this.idType.get(id).getCustomFieldType() : "";
        return object instanceof AbstractSingleFieldType && (abstractSingleFieldType = (AbstractSingleFieldType)object).getDescriptor() != null && (descriptor = abstractSingleFieldType.getDescriptor()).getModuleClass() != null && descriptor.getModuleClass().getName().equals("com.atlassian.jira.issue.customfields.impl.NumberCFType");
    }

    public Double getCustomFieldNumber(String id, Issue issue) {
        if (issue.getCustomFieldValue(this.idType.get(id)) instanceof Double) {
            return (Double)issue.getCustomFieldValue(this.idType.get(id));
        }
        return 0.0;
    }
}

