/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.UrlBuilder;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShowLinkServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final ActiveObjects activeObjects;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;

    public ShowLinkServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, ActiveObjects activeObjects, PluginLicenseManager pluginLicenseManager, UserManager userManager) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.activeObjects = activeObjects;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            String filterShareId = request.getParameter("filterShareId");
            if (filterShareId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"filterShareId"}));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShare filterShare = filterShareManager.findFilterShareById(Integer.valueOf(filterShareId));
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{filterShareId}));
            }
            UrlBuilder urlBuilder = new UrlBuilder();
            String shareLinkUrl = urlBuilder.buildUrl(filterShare);
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ApplicationUser currentUser = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            ApplicationUser userFromToken = ComponentAccessor.getUserManager().getUserByKey(filterShare.getToken().getUserKey());
            if (currentUser == null || userFromToken == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            if (!this.userManager.isSystemAdmin(userProfile.getUserKey()) && !currentUser.equals((Object)userFromToken)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
            }
            context.put("shareLinkUrl", shareLinkUrl);
            context.put("shareLinkUrlEncoded", URLEncoder.encode(shareLinkUrl, "UTF-8"));
            context.put("baseUrl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
            this.templateRenderer.render("templates/filter/showLinkDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }
}

