/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldRenderer;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.common.RequestDataProvider;
import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.common.ShowShareBaseValidator;
import aptis.plugins.shareYourJira.filter.FilterIssueManager;
import aptis.plugins.shareYourJira.filter.TableSortValueProvider;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShowFilterServlet
extends HttpServlet {
    private TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final DisplayFieldManager displayFieldManager;
    private final FieldRenderer fieldRenderer;
    private final FilterShareManager filterShareManager;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final ActiveObjects activeObjects;
    private final CustomFieldManager customFieldManager;

    public ShowFilterServlet(TemplateRenderer templateRenderer, ActiveObjects activeObjects, ApplicationProperties applicationProperties, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, SearchRequestService searchRequestService, SearchService searchService, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.displayFieldManager = new DisplayFieldManager(activeObjects);
        this.fieldRenderer = new FieldRenderer(this.i18nResolver, this.templateRenderer, dateTimeFormatterFactory);
        this.searchRequestService = searchRequestService;
        TokenManager tokenManager = new TokenManager(activeObjects);
        this.filterShareManager = new FilterShareManager(activeObjects, tokenManager, this.displayFieldManager);
        this.searchService = searchService;
        this.activeObjects = activeObjects;
        this.customFieldManager = ComponentAccessor.getCustomFieldManager();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            if (request.getParameter("id") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"id"}));
            }
            if (request.getParameter("token") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"token"}));
            }
            int shareId = Integer.parseInt(request.getParameter("id"));
            String givenToken = request.getParameter("token");
            FilterShare filterShare = this.filterShareManager.findFilterShareById(shareId);
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ShowShareBaseValidator showShareBaseValidator = new ShowShareBaseValidator();
            if (!showShareBaseValidator.isShareItemValidForCall(filterShare, request)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            if (!givenToken.equals(filterShare.getToken().getToken())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ApplicationUser userFromToken = ComponentAccessor.getUserManager().getUserByKey(filterShare.getToken().getUserKey());
            if (userFromToken == null || !userFromToken.isActive()) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(userFromToken);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterShare.getFilterId()));
            if (filter == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            FilterIssueManager filterIssueManager = new FilterIssueManager(this.activeObjects);
            List<Issue> allIssuesFormFilter = filterIssueManager.getIssuesFromFilter(filter, userFromToken);
            List<Project> projectsWithoutSharePermission = filterIssueManager.getProjectsWithoutSharePermission(allIssuesFormFilter, userFromToken);
            List<Issue> filteredIssues = filterIssueManager.getIssuesFilteredByExcludedProjects(allIssuesFormFilter, projectsWithoutSharePermission);
            TableSortValueProvider tableSortValueProvider = new TableSortValueProvider(this.displayFieldManager.getListOfDisplayFieldIds(filterShare), this.customFieldManager.getCustomFieldObjects());
            context.put("tableSortValueProvider", tableSortValueProvider);
            context.put("filter", filter);
            context.put("issues", filteredIssues);
            context.put("displayingFields", this.displayFieldManager.getListOfDisplayFieldIds(filterShare));
            context.put("title", filter.getName());
            context.put("fieldRenderer", this.fieldRenderer);
            context.put("baseUrl", this.applicationProperties.getString("jira.baseurl"));
            context.put("jiraTitle", ComponentAccessor.getApplicationProperties().getString("jira.title"));
            context.put("shareId", shareId);
            context.put("givenToken", givenToken);
            if (filterShare.getPasswordHash() == null) {
                this.templateRenderer.render("/templates/filter/sharedViewDocument.vm", context, (Writer)response.getWriter());
                this.countCall(filterShare, request);
            } else {
                char[] passwordEnteredByUser;
                char[] cArray = passwordEnteredByUser = request.getParameter("password") != null ? request.getParameter("password").toCharArray() : null;
                if (passwordEnteredByUser == null) {
                    this.templateRenderer.render("/templates/common/askForPasswordDocument.vm", context, (Writer)response.getWriter());
                } else {
                    PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
                    if (passwordHashConverter.authenticate(passwordEnteredByUser, filterShare.getPasswordHash()).booleanValue()) {
                        this.templateRenderer.render("/templates/filter/sharedViewDocument.vm", context, (Writer)response.getWriter());
                        this.countCall(filterShare, request);
                    } else {
                        context.put("showWrongInputNotification", true);
                        this.templateRenderer.render("/templates/common/askForPasswordDocument.vm", context, (Writer)response.getWriter());
                    }
                }
            }
        }
        catch (Exception exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("/templates/errorDocumentForExternalUser.vm", context, (Writer)response.getWriter());
        }
    }

    private void countCall(FilterShare filterShare, HttpServletRequest request) {
        ShareHistoryManager shareHistoryManager = new ShareHistoryManager(this.activeObjects);
        JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        if (jiraAuthenticationContext.isLoggedInUser()) {
            shareHistoryManager.addFilterCalled(filterShare.getFilterId(), filterShare.getID(), jiraAuthenticationContext.getLoggedInUser());
        } else {
            shareHistoryManager.addFilterCalled(filterShare.getFilterId(), filterShare.getID(), RequestDataProvider.getClientIPAddress(request));
        }
    }
}

