/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.UrlBuilder;
import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.filter.CreateShareLinkRequest;
import aptis.plugins.shareYourJira.filter.CreateShareLinkResponse;
import aptis.plugins.shareYourJira.filter.DeleteShareLinkRequest;
import aptis.plugins.shareYourJira.filter.EditShareLinkRequest;
import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import aptis.plugins.shareYourJira.history.ShareHistoryLogItemFormatter;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/filterShareLink")
public class ShareLinkRestService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final SearchRequestService searchRequestService;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final ShareHistoryManager shareHistoryManager;
    private final ShareHistoryLogItemFormatter shareHistoryLogItemFormatter;
    private final UrlBuilder urlBuilder;

    public ShareLinkRestService(ActiveObjects activeObjects, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, SearchRequestService searchRequestService, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.searchRequestService = searchRequestService;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.shareHistoryManager = new ShareHistoryManager(activeObjects);
        this.shareHistoryLogItemFormatter = new ShareHistoryLogItemFormatter();
        this.urlBuilder = new UrlBuilder();
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            String filterIdParameter = request.getParameter("filterId");
            if (filterIdParameter == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"filterId"}));
            }
            Long filterId = Long.parseLong(filterIdParameter);
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ApplicationUser applicationUser = jiraAuthenticationContext.getLoggedInUser();
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(applicationUser);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, filterId);
            if (filter == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(filterId)})).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            List<FilterShare> shareList = filterShareManager.getAllFilterShareForFilter(filter);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Gson gson = new Gson();
            JsonArray jsonResult = new JsonArray();
            shareList.forEach(share -> {
                JsonObject configuration = new JsonObject();
                configuration.addProperty("id", share.getID());
                configuration.addProperty("active", share.isActive());
                configuration.addProperty("validPeriodFrom", share.getValidPeriodFrom() != null ? dateFormat.format(share.getValidPeriodFrom()) : null);
                configuration.addProperty("validPeriodTo", share.getValidPeriodTo() != null ? dateFormat.format(share.getValidPeriodTo()) : null);
                configuration.addProperty("hasPassword", share.getPasswordHash() != null && !share.getPasswordHash().equals(""));
                configuration.addProperty("ipsLock", share.getIPsLock());
                configuration.addProperty("onlyLoggedInUser", share.getOnlyLoggedInUser());
                JsonArray displayingFields = new JsonArray();
                for (String field : displayFieldManager.getListOfDisplayFieldIds((FilterShare)share)) {
                    displayingFields.add(new JsonPrimitive(field));
                }
                configuration.add("displayingFields", displayingFields);
                JsonObject entry = new JsonObject();
                entry.addProperty("id", share.getID());
                entry.addProperty("isActive", share.isActive());
                entry.addProperty("callCount", this.shareHistoryManager.getCountCallsByShareId(share.getID(), ShareHistoryItem.SharedItemType.FILTER));
                entry.addProperty("token", share.getToken().getToken());
                entry.addProperty("shareLinkUrl", this.urlBuilder.buildUrl((FilterShare)share));
                entry.addProperty("createdDate", this.shareHistoryManager.getCreatedDateByShareId(share.getID(), ShareHistoryItem.SharedItemType.FILTER).toString());
                ApplicationUser shareUser = this.shareHistoryManager.getShareCreatorByShareId(share.getID(), ShareHistoryItem.SharedItemType.FILTER);
                JsonObject userJson = new JsonObject();
                if (shareUser != null) {
                    JsonObject avatarUrls = new JsonObject();
                    avatarUrls.addProperty("16x16", ComponentAccessor.getAvatarService().getAvatarURL(jiraAuthenticationContext.getLoggedInUser(), shareUser, Avatar.Size.SMALL).toString());
                    userJson.add("avatarUrls", avatarUrls);
                    userJson.addProperty("displayName", shareUser.getDisplayName());
                    userJson.addProperty("key", shareUser.getKey());
                    userJson.addProperty("name", shareUser.getName());
                } else {
                    userJson.addProperty("displayName", this.shareHistoryManager.getShareCreatorDisplayNameByShareId(share.getID(), ShareHistoryItem.SharedItemType.FILTER));
                }
                entry.add("creator", userJson);
                entry.add("configuration", configuration);
                jsonResult.add(entry);
            });
            return Response.ok((Object)gson.toJson(jsonResult)).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response post(CreateShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(config.getFilterId()));
            if (filter == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(config.getFilterId())})).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShare filterShare = filterShareManager.createFilterShare(user, filter, config);
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            this.shareHistoryManager.addFilterCreated(filter.getId(), filterShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForFilter(i18nHelper, this.i18nResolver, this.dateTimeFormatterFactory, config), user);
            String shareLinkUrl = this.urlBuilder.buildUrl(filterShare);
            CreateShareLinkResponse response = new CreateShareLinkResponse();
            response.setFilterShareId(filterShare.getID());
            response.setFilterShareUrl(shareLinkUrl);
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(EditShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShare filterShare = filterShareManager.findFilterShareById(config.getId());
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            if (!filterShare.getToken().getUserKey().equals(user.getKey()) && !ComponentAccessor.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (config.getDisplayingFields() == null) {
                displayFieldManager.updateDisplayFields(filterShare, new ArrayList<String>());
            } else {
                displayFieldManager.updateDisplayFields(filterShare, config.getDisplayingFields());
            }
            filterShare.setValidPeriodFrom(config.getValidPeriodFrom());
            filterShare.setValidPeriodTo(config.getValidPeriodTo());
            filterShare.setIPsLock(config.getIPsLock());
            filterShare.setNote(config.getNote());
            filterShare.setOnlyLoggedInUser(config.getOnlyLoggedInUser());
            PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
            Boolean hasPassword = config.getHasPassword();
            if (hasPassword != null && !hasPassword.booleanValue()) {
                filterShare.setPasswordHash(null);
            } else if (config.getPassword() != null) {
                filterShare.setPasswordHash(passwordHashConverter.hashPassword(config.getPassword().toCharArray()));
            }
            filterShare.save();
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(jiraAuthenticationContext.getLocale());
            this.shareHistoryManager.addFilterChanged(filterShare.getFilterId(), filterShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForFilter(i18nHelper, this.i18nResolver, this.dateTimeFormatterFactory, config), user);
            CreateShareLinkResponse response = new CreateShareLinkResponse();
            response.setFilterShareId(filterShare.getID());
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete(DeleteShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShare filterShare = filterShareManager.findFilterShareById(config.getId());
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            if (!filterShare.getToken().getUserKey().equals(user.getKey()) && !ComponentAccessor.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            filterShareManager.deleteFilterShare(filterShare);
            this.shareHistoryManager.addFilterDeleted(filterShare.getFilterId(), filterShare.getID(), user);
            return Response.ok().build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="activeStatus")
    public Response activate(EditShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShare filterShare = filterShareManager.findFilterShareById(config.getId());
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            if (!filterShare.getToken().getUserKey().equals(user.getKey()) && !ComponentAccessor.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            filterShare.setActive(config.getActive());
            filterShare.save();
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(jiraAuthenticationContext.getLocale());
            this.shareHistoryManager.addFilterChanged(filterShare.getFilterId(), filterShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForActiveStatus(i18nHelper, filterShare), user);
            return Response.ok().build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

