/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.bridge.BridgeManager;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.List;

public class FilterIssueManager {
    private final BridgeManager bridgeManager = new BridgeManager();
    private final ProjectSettingsManager projectSettingsManager;

    public FilterIssueManager(ActiveObjects activeObjects) {
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
    }

    public List<Issue> getIssuesFromFilter(SearchRequest filter, ApplicationUser user) throws SearchException {
        Query query = filter.getQuery();
        return this.bridgeManager.getSearchService().search(query, user);
    }

    public List<Project> getProjectsWithoutSharePermission(List<Issue> issues, ApplicationUser user) {
        List<Project> projectsFromIssues = this.getProjectsFromIssues(issues);
        ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
        ArrayList<Project> projectsWithoutPermission = new ArrayList<Project>();
        for (Project project : projectsFromIssues) {
            ProjectSetting projectSetting;
            if (projectPermissionManager.isUserInProjectRole(user, project, ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSetting = this.projectSettingsManager.findSetting(project.getId())))) continue;
            projectsWithoutPermission.add(project);
        }
        return projectsWithoutPermission;
    }

    private List<Project> getProjectsFromIssues(List<Issue> issues) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Issue issue : issues) {
            if (projects.contains(issue.getProjectObject())) continue;
            projects.add(issue.getProjectObject());
        }
        return projects;
    }

    public List<Issue> getIssuesFilteredByExcludedProjects(List<Issue> issues, List<Project> excludeProjects) throws SearchException {
        if (issues.size() == 0 || excludeProjects.size() == 0) {
            return issues;
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue issue : issues) {
            if (excludeProjects.contains(issue.getProjectObject())) continue;
            result.add(issue);
        }
        return result;
    }
}

