/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.shareYourJira.filter.FilterIssueManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/filterInformation/{filterId}")
public class FilterInformationRestService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final SearchRequestService searchRequestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public FilterInformationRestService(JiraAuthenticationContext jiraAuthenticationContext, ActiveObjects activeObjects, I18nResolver i18nResolver, SearchRequestService searchRequestService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.searchRequestService = searchRequestService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="filterId") Long filterId) {
        try {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (!this.jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (filterId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"filterId"}));
            }
            Gson gson = new Gson();
            JsonObject jsonResult = new JsonObject();
            SearchRequest filter = this.getFilter(user, filterId);
            if (filter == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(filterId)})).build();
            }
            List<String> fields = DisplayFieldManager.getDisplayingFieldIdsByFilter(filter, user);
            JsonObject warningProperty = this.getWarningProperty(user, filter);
            JsonArray jsonFields = new JsonArray();
            for (String fieldId : fields) {
                jsonFields.add(new JsonPrimitive(fieldId));
            }
            jsonResult.add("fields", jsonFields);
            if (warningProperty != null) {
                jsonResult.add("warning", warningProperty);
            }
            return Response.ok((Object)gson.toJson(jsonResult)).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @Nullable
    private SearchRequest getFilter(ApplicationUser user, Long filterId) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        return this.searchRequestService.getFilter((JiraServiceContext)serviceContext, filterId);
    }

    @Nullable
    private JsonObject getWarningProperty(ApplicationUser user, SearchRequest filter) throws SearchException {
        FilterIssueManager filterIssueManager = new FilterIssueManager(this.activeObjects);
        List<Issue> issues = filterIssueManager.getIssuesFromFilter(filter, user);
        List<Project> projectsWithoutSharePermission = filterIssueManager.getProjectsWithoutSharePermission(issues, user);
        List<Issue> filteredIssues = filterIssueManager.getIssuesFilteredByExcludedProjects(issues, projectsWithoutSharePermission);
        if (projectsWithoutSharePermission.size() > 0) {
            JsonObject warningProperty = new JsonObject();
            JsonArray projectList = new JsonArray();
            for (Project project : projectsWithoutSharePermission) {
                JsonObject jsonProject = new JsonObject();
                jsonProject.addProperty("id", project.getId());
                jsonProject.addProperty("key", project.getKey());
                jsonProject.addProperty("name", project.getName());
                projectList.add(jsonProject);
            }
            warningProperty.add("projectsWithoutPermission", projectList);
            warningProperty.addProperty("filterIssueCount", issues.size());
            warningProperty.addProperty("sharedIssueCount", filteredIssues.size());
            return warningProperty;
        }
        return null;
    }
}

