/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldProvider;
import aptis.plugins.common.HtmlFormatter;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplateManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditShareLinkServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final ActiveObjects activeObjects;
    private final FieldProvider fieldProvider;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final SearchRequestService searchRequestService;

    public EditShareLinkServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, ActiveObjects activeObjects, PluginLicenseManager pluginLicenseManager, UserManager userManager, SearchRequestService searchRequestService) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.activeObjects = activeObjects;
        this.pluginLicenseManager = pluginLicenseManager;
        this.fieldProvider = new FieldProvider();
        this.userManager = userManager;
        this.searchRequestService = searchRequestService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            String filterShareId = request.getParameter("filterShareId");
            if (filterShareId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"filterShareId"}));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            FilterShare filterShare = filterShareManager.findFilterShareById(Integer.valueOf(filterShareId));
            if (filterShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(filterShareId)}));
            }
            if (!this.userManager.isSystemAdmin(userProfile.getUserKey()) && !userProfile.getUserKey().getStringValue().equals(filterShare.getToken().getUserKey())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
            }
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterShare.getFilterId()));
            if (filter == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(filterShare.getFilterId())}));
            }
            context.put("isDefaultSMTPMailServerDefined", ComponentAccessor.getMailServerManager().isDefaultSMTPMailServerDefined());
            context.put("ShareTemplatesOfUser", shareTemplateManager.getAllShareTemplatesCreatedByUser(user));
            context.put("user", user);
            context.put("title", this.i18nResolver.getText("aptis-sjy-edit-filter-share-link-title"));
            context.put("allFields", this.fieldProvider.getAllFieldsForFilterShare());
            context.put("displayingFields", displayFieldManager.getListOfDisplayFieldIds(filterShare));
            context.put("filter", filter);
            context.put("filterShareId", filterShareId);
            context.put("validPeriodFromChecked", filterShare.getValidPeriodFrom() != null);
            context.put("validPeriodFrom", filterShare.getValidPeriodFrom() == null ? HtmlFormatter.toHtmlDate(new Date()) : HtmlFormatter.toHtmlDate(filterShare.getValidPeriodFrom()));
            context.put("validPeriodToChecked", filterShare.getValidPeriodTo() != null);
            context.put("validPeriodTo", filterShare.getValidPeriodTo() == null ? HtmlFormatter.toHtmlDate(new Date()) : HtmlFormatter.toHtmlDate(filterShare.getValidPeriodTo()));
            context.put("passwordChecked", filterShare.getPasswordHash() != null);
            context.put("password", filterShare.getPasswordHash() != null ? "PASSWORD_PLACEHOLDER" : "");
            context.put("ipsLockChecked", filterShare.getIPsLock() != null);
            context.put("ipsLock", filterShare.getIPsLock());
            context.put("note", filterShare.getNote());
            context.put("onlyLoggedInUserChecked", filterShare.getOnlyLoggedInUser());
            context.put("localesJsonHtml", this.getLocales().toString());
            this.templateRenderer.render("templates/filter/shareLinkDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    protected JsonObject getLocales() {
        JsonObject locales = new JsonObject();
        locales.addProperty("mailSubject", this.i18nResolver.getText("jira-share-plugin.email.issue.subject"));
        return locales;
    }
}

