/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.filter;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldProvider;
import aptis.plugins.common.HtmlFormatter;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.filter.FilterIssueManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplateManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CreateShareLinkServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final SearchRequestService searchRequestService;
    private final ActiveObjects activeObjects;

    public CreateShareLinkServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, UserManager userManager, SearchRequestService searchRequestService, SearchService searchService, ActiveObjects activeObjects) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.searchRequestService = searchRequestService;
        this.activeObjects = activeObjects;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            String filterId = request.getParameter("filterId");
            if (filterId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"filterId"}));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(Long.parseLong(filterId)));
            if (filter == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{filterId}));
            }
            FilterIssueManager filterIssueManager = new FilterIssueManager(this.activeObjects);
            List<Issue> allIssuesFormFilter = filterIssueManager.getIssuesFromFilter(filter, user);
            List<Project> projectsWithoutSharePermission = filterIssueManager.getProjectsWithoutSharePermission(allIssuesFormFilter, user);
            List<Issue> filteredIssues = filterIssueManager.getIssuesFilteredByExcludedProjects(allIssuesFormFilter, projectsWithoutSharePermission);
            if (projectsWithoutSharePermission.size() > 0) {
                String projectList = "";
                for (Project project : projectsWithoutSharePermission) {
                    projectList = projectList + "<li>" + project.getName() + "</li>\n";
                }
                context.put("warningText", this.i18nResolver.getText("aptis-sjy-not-all-projects-has-share-permission", (Serializable[])new String[]{String.valueOf(filteredIssues.size()), String.valueOf(allIssuesFormFilter.size()), projectList}));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            FieldProvider fieldProvider = new FieldProvider();
            context.put("isDefaultSMTPMailServerDefined", ComponentAccessor.getMailServerManager().isDefaultSMTPMailServerDefined());
            context.put("ShareTemplatesOfUser", shareTemplateManager.getAllShareTemplatesCreatedByUser(user));
            context.put("user", user);
            context.put("title", this.i18nResolver.getText("aptis-sjy-create-filter-share-link-title"));
            context.put("allFields", fieldProvider.getAllFieldsForFilterShare());
            context.put("displayingFields", DisplayFieldManager.getDisplayingFieldIdsByFilter(filter, user));
            context.put("filter", filter);
            context.put("validPeriodFromChecked", false);
            context.put("validPeriodFrom", HtmlFormatter.toHtmlDate(new Date()));
            context.put("validPeriodToChecked", false);
            context.put("validPeriodTo", HtmlFormatter.toHtmlDate(new Date()));
            context.put("passwordChecked", false);
            context.put("password", "");
            context.put("ipsLockChecked", false);
            context.put("ipsLock", "");
            context.put("onlyLoggedInUserChecked", false);
            context.put("localesJsonHtml", this.getLocales().toString());
            this.templateRenderer.render("templates/filter/shareLinkDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    protected JsonObject getLocales() {
        JsonObject locales = new JsonObject();
        locales.addProperty("mailSubject", this.i18nResolver.getText("jira-share-plugin.email.issue.subject"));
        return locales;
    }
}

