/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.customfield;

import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueAutomaticShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueAutomaticShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.UrlBuilder;
import javax.annotation.Nullable;

public class CustomFieldShareLink
extends GenericTextCFType {
    private final ActiveObjects activeObjects;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueAutomaticShareManager shareManager;
    private final ProjectSettingsManager projectSettingsManager;

    public CustomFieldShareLink(CustomFieldValuePersister customFieldValuePersister, ApplicationProperties applicationProperties, GenericConfigManager genericConfigManager, ActiveObjects activeObjects) {
        super(customFieldValuePersister, genericConfigManager);
        this.activeObjects = activeObjects;
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.shareManager = new IssueAutomaticShareManager(this.activeObjects);
        this.projectSettingsManager = new ProjectSettingsManager(this.activeObjects);
    }

    @Nullable
    public String getValueFromIssue(CustomField field, Issue issue) {
        String token = this.getToken(issue);
        if (token == null && this.isAutoShareActive(issue).booleanValue()) {
            try {
                token = this.createToken(issue);
            }
            catch (Exception exception) {
                return "ERROR: COULD NOT GENERATE URL";
            }
        }
        if (token != null) {
            return this.buildUrl(token, issue);
        }
        return null;
    }

    private String buildUrl(String token, Issue issue) {
        UrlBuilder urlBuilder = new UrlBuilder(this.applicationProperties.getString("jira.baseurl") + "/plugins/servlet/shareYourJira/showIssue", false);
        urlBuilder.addParameter("token", token);
        urlBuilder.addParameter("issueId", (Object)issue.getId());
        return urlBuilder.asUrlString();
    }

    private TokenManager getTokenManager() {
        return new TokenManager(this.activeObjects);
    }

    private Boolean isAutoShareActive(Issue issue) {
        Long projectId = issue.getProjectId();
        if (projectId == null) {
            return false;
        }
        ProjectSetting projectSettings = this.projectSettingsManager.findSetting(projectId);
        if (projectSettings == null) {
            return false;
        }
        return projectSettings.isAutomaticShareActive();
    }

    @Nullable
    private String getToken(Issue issue) {
        if (!issue.isCreated()) {
            return null;
        }
        IssueAutomaticShare share = this.shareManager.findByIssueId(issue.getId());
        if (share != null) {
            return share.getToken();
        }
        return null;
    }

    @Nullable
    private String createToken(Issue issue) {
        if (issue.getId() == null) {
            return null;
        }
        IssueAutomaticShare share = this.shareManager.createIssueShare(issue);
        if (share != null) {
            return share.getToken();
        }
        return null;
    }
}

