/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.shareYourJira.common.AttachmentManager;
import aptis.plugins.shareYourJira.common.CommentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/visibilityOptions")
public class VisibilityOptionsService {
    private I18nResolver i18nResolver;
    private CommentManager commentManager;
    private AttachmentManager attachmentManager;
    private IssueManager issueManager;

    public VisibilityOptionsService(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.commentManager = new CommentManager(this.i18nResolver);
        this.attachmentManager = new AttachmentManager(this.i18nResolver);
        this.issueManager = ComponentAccessor.getIssueManager();
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            String issueId = request.getParameter("issueId");
            if (issueId == null) {
                return Response.serverError().entity((Object)this.i18nResolver.getText("aptis-syj-visibility-service-error")).build();
            }
            MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(Long.parseLong(issueId)));
            JSONArray commentVisibilityOptions = this.commentManager.getVisibilityOptions((Issue)issue);
            JSONArray attachmentVisibilityOptions = this.attachmentManager.getVisibilityOptions((Issue)issue);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("commentVisibilityOptions", (Object)commentVisibilityOptions);
            jsonObject.put("attachmentVisibilityOptions", (Object)attachmentVisibilityOptions);
            return Response.ok((Object)jsonObject.toString()).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

