/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/userPicker")
public class UserPickerRestService {
    private final UserSearchService userSearchService;
    private final I18nResolver i18nResolver;

    public UserPickerRestService(UserSearchService userSearchService, I18nResolver i18nResolver) {
        this.userSearchService = userSearchService;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            JSONArray usersJson = new JSONArray();
            String searchText = request.getParameter("searchText");
            if (searchText == null || searchText.length() == 0) {
                return Response.ok((Object)usersJson.toString()).build();
            }
            List foundUsers = this.userSearchService.findUsers(searchText, new UserSearchParams(false, true, false));
            if (foundUsers.size() == 0) {
                if (this.isValidEmailAddress(searchText)) {
                    JSONObject userJson = new JSONObject();
                    userJson.put("formatSelection", (Object)searchText);
                    userJson.put("formatResult", (Object)(searchText + " (" + this.i18nResolver.getText("inviteuser.results.email") + ")"));
                    userJson.put("email", (Object)searchText);
                    usersJson.put((Object)userJson);
                }
            } else {
                for (ApplicationUser user : foundUsers) {
                    JSONObject userJson = new JSONObject();
                    userJson.put("formatSelection", (Object)user.getDisplayName());
                    userJson.put("formatResult", (Object)user.getDisplayName());
                    userJson.put("email", (Object)user.getEmailAddress());
                    usersJson.put((Object)userJson);
                }
            }
            return Response.ok((Object)usersJson.toString()).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    private boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }
}

