/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.common.RequestDataProvider;
import aptis.plugins.shareYourJira.sharedContainer.ShareItem;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;

public class ShowShareBaseValidator {
    public boolean isShareItemValidForCall(ShareItem shareItem, HttpServletRequest request) throws Exception {
        if (shareItem.isActive() != null && !shareItem.isActive().booleanValue()) {
            return false;
        }
        if (shareItem.getIPsLock() != null) {
            String ipAddress = RequestDataProvider.getClientIPAddress(request);
            String[] allowedAddresses = shareItem.getIPsLock().replaceAll("\\s", "").split(",");
            boolean ipChecksOut = false;
            for (String allowedAddress : allowedAddresses) {
                if (!ipAddress.matches(allowedAddress)) continue;
                ipChecksOut = true;
                break;
            }
            if (!ipChecksOut) {
                return false;
            }
        }
        if (shareItem.getValidPeriodFrom() != null && this.zeroTime(new Date()).getTime() < this.zeroTime(shareItem.getValidPeriodFrom()).getTime()) {
            return false;
        }
        if (shareItem.getValidPeriodTo() != null && this.zeroTime(new Date()).getTime() > this.zeroTime(shareItem.getValidPeriodTo()).getTime()) {
            return false;
        }
        if (shareItem.getOnlyLoggedInUser() != null) {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (shareItem.getOnlyLoggedInUser().booleanValue() && !jiraAuthenticationContext.isLoggedInUser()) {
                return false;
            }
        }
        return true;
    }

    private Date zeroTime(Date dateTime) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(dateTime);
        result.set(10, 0);
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result.getTime();
    }
}

