/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ShareSettingsJsonBuilder {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final DisplayFieldManager displayFieldManager;

    public ShareSettingsJsonBuilder(DisplayFieldManager displayFieldManager) {
        this.displayFieldManager = displayFieldManager;
    }

    public JsonObject getJsonSettingsForIssueShare(IssueShare share) {
        JsonObject configuration = this.getBaseSettingsJson(share.getID(), share.isActive(), share.getValidPeriodFrom(), share.getValidPeriodTo(), share.getPasswordHash(), share.getIPsLock(), share.getOnlyLoggedInUser() != null ? share.getOnlyLoggedInUser() : false, this.displayFieldManager.getListOfDisplayFieldIds(share));
        JsonArray commentVisibility = new JsonArray();
        if (share.getCommentVisibilityString() != null) {
            for (String field : share.getCommentVisibilityString().split(";")) {
                if (field.length() == 0) continue;
                commentVisibility.add(new JsonPrimitive(field));
            }
        }
        JsonArray attachmentVisibility = new JsonArray();
        if (share.getAttachmentVisibilityString() != null) {
            for (String field : share.getAttachmentVisibilityString().split(";")) {
                if (field.length() == 0) continue;
                attachmentVisibility.add(new JsonPrimitive(field));
            }
        }
        configuration.add("commentVisibility", commentVisibility.size() > 0 ? commentVisibility : null);
        configuration.add("attachmentVisibility", attachmentVisibility.size() > 0 ? attachmentVisibility : null);
        return configuration;
    }

    public JsonObject getJsonSettingsForFilterShare(FilterShare share) {
        return this.getBaseSettingsJson(share.getID(), share.isActive(), share.getValidPeriodFrom(), share.getValidPeriodTo(), share.getPasswordHash(), share.getIPsLock(), share.getOnlyLoggedInUser() != null ? share.getOnlyLoggedInUser() : false, this.displayFieldManager.getListOfDisplayFieldIds(share));
    }

    private JsonObject getBaseSettingsJson(int id, boolean isActive, Date validPeriodFrom, Date validPeriodTo, String passwordHash, String ipsLock, boolean onlyLoggedInuser, List<String> shareFields) {
        JsonObject configuration = new JsonObject();
        configuration.addProperty("id", id);
        configuration.addProperty("active", isActive);
        configuration.addProperty("validPeriodFrom", validPeriodFrom != null ? this.dateFormat.format(validPeriodFrom) : null);
        configuration.addProperty("validPeriodTo", validPeriodTo != null ? this.dateFormat.format(validPeriodTo) : null);
        configuration.addProperty("hasPassword", passwordHash != null && !passwordHash.equals(""));
        configuration.addProperty("ipsLock", ipsLock);
        configuration.addProperty("onlyLoggedInUser", onlyLoggedInuser);
        JsonArray displayingFields = new JsonArray();
        for (String field : shareFields) {
            displayingFields.add(new JsonPrimitive(field));
        }
        configuration.add("displayingFields", displayingFields);
        return configuration;
    }
}

