/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.UrlBuilder;
import aptis.plugins.shareYourJira.common.EMailManager;
import aptis.plugins.shareYourJira.common.SendMailRequest;
import aptis.plugins.shareYourJira.common.SendMailResponse;
import aptis.plugins.shareYourJira.history.ShareHistoryLogItemFormatter;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.issue.CanShareIssueCondition;
import aptis.plugins.shareYourJira.setting.GlobalSetting;
import aptis.plugins.shareYourJira.setting.GlobalSettingManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.setting.SettingProvider;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.web.util.HtmlUtils;

@Path(value="/mailShare")
public class SendMailRestService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final UrlBuilder urlBuilder;
    private final ProjectSettingsManager projectSettingsManager;
    private final GlobalSettingManager globalSettingManager;
    private final SettingProvider settingProvider;
    private final TemplateRenderer templateRenderer;
    private final PluginLicenseManager pluginLicenseManager;
    private final SearchRequestService searchRequestService;
    private final ShareHistoryManager shareHistoryManager;
    private final ShareHistoryLogItemFormatter shareHistoryLogItemFormatter;

    public SendMailRestService(ActiveObjects activeObjects, I18nResolver i18nResolver, TemplateRenderer templateRenderer, PluginLicenseManager pluginLicenseManager, SearchRequestService searchRequestService) {
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.urlBuilder = new UrlBuilder();
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
        this.globalSettingManager = new GlobalSettingManager(activeObjects);
        this.settingProvider = new SettingProvider();
        this.templateRenderer = templateRenderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.searchRequestService = searchRequestService;
        this.shareHistoryManager = new ShareHistoryManager(activeObjects);
        this.shareHistoryLogItemFormatter = new ShareHistoryLogItemFormatter();
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(SendMailRequest config, @Context HttpServletRequest request) {
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            SendMailResponse response = new SendMailResponse();
            if (config.getAddresses().size() == 0) {
                return Response.ok((Object)response).build();
            }
            String recipients = String.join((CharSequence)"; ", config.getAddresses());
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            String summaryForEMailSent = this.shareHistoryLogItemFormatter.getShareSummaryForEMailSent(i18nHelper, config.getAddresses(), config.getNote());
            switch (config.getContext()) {
                case "issue": {
                    IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
                    IssueShare issueShare = issueShareManager.findIssueShareById(config.getId());
                    if (issueShare == null) {
                        throw new NotFoundException(this.i18nResolver.getText("aptis-syj-share-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
                    }
                    MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(issueShare.getIssueId()));
                    if (issue == null) {
                        throw new NotFoundException(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(issueShare.getIssueId())}));
                    }
                    CanShareIssueCondition canShareIssueCondition = new CanShareIssueCondition(this.activeObjects);
                    JiraHelper jiraHelper = new JiraHelper();
                    if (!canShareIssueCondition.shouldDisplay(user, (Issue)issue, jiraHelper)) {
                        throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
                    }
                    this.sendIssueEmail(config, issueShare, (Issue)issue, response, user);
                    this.shareHistoryManager.addIssueShared(issue.getId(), issueShare.getID(), summaryForEMailSent, user, recipients);
                    break;
                }
                case "filter": {
                    FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
                    FilterShare filterShare = filterShareManager.findFilterShareById(config.getId());
                    if (filterShare == null) {
                        throw new NotFoundException(this.i18nResolver.getText("aptis-syj-share-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
                    }
                    JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
                    SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterShare.getFilterId()));
                    if (filter == null) {
                        throw new NotFoundException(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
                    }
                    this.sendFilterMail(config, filterShare, filter, response, user);
                    this.shareHistoryManager.addFilterShared(filter.getId(), filterShare.getID(), summaryForEMailSent, user, recipients);
                    break;
                }
                default: {
                    throw new NotFoundException(this.i18nResolver.getText("aptis-syj-unknown-share-type", new Serializable[]{config.getContext()}));
                }
            }
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    private void sendIssueEmail(SendMailRequest config, IssueShare issueShare, Issue issue, SendMailResponse response, ApplicationUser user) {
        String shareLinkUrl = this.urlBuilder.buildUrl(issueShare);
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        String subject = issue.getSummary() + " (" + issue.getKey() + ")";
        context.put("subject", subject);
        context.put("subjectHtml", this.i18nResolver.getText("aptis-syj-share-email-subject", (Serializable[])new String[]{"<strong>" + user.getDisplayName() + "</strong>"}));
        context.put("issueSummary", issue.getSummary());
        context.put("summary", issue.getSummary());
        context.put("shareLinkUrl", shareLinkUrl);
        if (config.getNote() != null) {
            context.put("eMailNote", config.getNote());
            context.put("eMailNoteHtml", HtmlUtils.htmlEscape((String)config.getNote()).replaceAll("(\r\n|\n)", "<br />"));
        }
        ProjectSetting projectSetting = this.projectSettingsManager.findSetting(issue.getProjectId());
        this.sendMail(config, subject, projectSetting, context, response);
    }

    private void sendFilterMail(SendMailRequest config, FilterShare filterShare, SearchRequest filter, SendMailResponse response, ApplicationUser user) {
        String shareLinkUrl = this.urlBuilder.buildUrl(filterShare);
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        String subject = filter.getName();
        context.put("subject", subject);
        context.put("subjectHtml", this.i18nResolver.getText("aptis-syj-share-filter-email-subject", (Serializable[])new String[]{"<strong>" + user.getDisplayName() + "</strong>"}));
        context.put("issueSummary", filter.getName());
        context.put("summary", filter.getName());
        context.put("shareLinkUrl", shareLinkUrl);
        if (config.getNote() != null) {
            context.put("eMailNote", config.getNote());
            context.put("eMailNoteHtml", HtmlUtils.htmlEscape((String)config.getNote()).replaceAll("(\r\n|\n)", "<br />"));
        }
        this.sendMail(config, subject, null, context, response);
    }

    private void sendMail(SendMailRequest config, String subject, ProjectSetting projectSetting, Map<String, Object> context, SendMailResponse response) {
        GlobalSetting globalSetting = this.globalSettingManager.findSetting();
        String mailSystem = this.settingProvider.getEmailSystem(projectSetting, globalSetting);
        if (mailSystem.equals("jeti")) {
            response.setSendUsingJeti(true);
            response.setJetiEmailTemplate(projectSetting.getJetiTemplate());
            response.setMailSubject(this.i18nResolver.getText("jira-share-plugin.email.issue.subject"));
            response.setShareUrl((String)context.get("shareLinkUrl"));
        } else {
            String customEmailTemplate = this.settingProvider.getMailTemplate(projectSetting, globalSetting);
            String mailBody = this.templateRenderer.renderFragment(customEmailTemplate, context);
            EMailManager eMailManager = new EMailManager();
            eMailManager.sendHtmlEMailToSingleUsers(config.getAddresses(), subject, mailBody);
        }
    }
}

