/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.shareYourJira.UrlBuilder;
import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.ShareItem;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.message.I18nResolver;

public class RenderHelper {
    private final IssueManager issueManager = ComponentAccessor.getIssueManager();
    private final UserManager jiraUserManager = ComponentAccessor.getUserManager();
    private final SearchRequestService searchRequestService;
    private final I18nResolver i18nResolver;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final UrlBuilder urlBuilder;
    private final ShareHistoryManager shareHistoryManager;
    private final AvatarService avatarService = ComponentAccessor.getAvatarService();

    public RenderHelper(SearchRequestService searchRequestService, I18nResolver i18nResolver, DateTimeFormatterFactory dateTimeFormatterFactory, ActiveObjects activeObjects) {
        this.searchRequestService = searchRequestService;
        this.i18nResolver = i18nResolver;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.urlBuilder = new UrlBuilder();
        this.shareHistoryManager = new ShareHistoryManager(activeObjects);
    }

    public boolean shareTargetExists(IssueShare issueShare, ApplicationUser user) {
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueShare.getIssueId()));
        return issue != null;
    }

    public boolean shareTargetExists(FilterShare filterShare, ApplicationUser user) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterShare.getFilterId()));
        return filter != null;
    }

    public String getName(IssueShare issueShare, ApplicationUser user) {
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueShare.getIssueId()));
        if (issue == null) {
            return this.i18nResolver.getText("jap.view.user.deleted");
        }
        return "[" + issue.getKey() + "] " + issue.getSummary();
    }

    public String getName(FilterShare filterShare, ApplicationUser user) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, Long.valueOf(filterShare.getFilterId()));
        if (filter == null) {
            return this.i18nResolver.getText("jap.view.user.deleted");
        }
        return filter.getName();
    }

    public String getKey(IssueShare issueShare, ApplicationUser user) {
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueShare.getIssueId()));
        if (issue == null) {
            return this.i18nResolver.getText("jap.view.user.deleted");
        }
        return issue.getKey();
    }

    public String getType(IssueShare issueShare) {
        return this.i18nResolver.getText("common.words.issue");
    }

    public String getType(FilterShare filterShare) {
        return this.i18nResolver.getText("timetracking.filter");
    }

    public String getCreatorName(ShareItem shareItem) {
        ApplicationUser user = this.getCreator(shareItem);
        if (user == null) {
            return "";
        }
        return user.getDisplayName();
    }

    public ApplicationUser getCreator(ShareItem shareItem) {
        return this.jiraUserManager.getUserByKey(shareItem.getToken().getUserKey());
    }

    public String getAvatarUrl(ApplicationUser currentUser, ApplicationUser userItem) {
        return this.avatarService.getAvatarURL(currentUser, userItem, Avatar.Size.SMALL).toString();
    }

    public String getCreatedDate(ShareItem shareItem) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        return dateTimeFormatter.format(shareItem.getToken().getCreated());
    }

    public String getCreatedDateSort(ShareItem issueShare) {
        return String.valueOf(issueShare.getToken().getCreated().getTime());
    }

    public String getUrl(IssueShare issueShare) {
        return this.urlBuilder.buildUrl(issueShare);
    }

    public String getJiraDetailUrl(IssueShare issueShare) {
        return this.urlBuilder.buildJiraDetailUrl(issueShare);
    }

    public int getCountCalls(IssueShare issueShare) {
        return this.shareHistoryManager.getCountCallsByShareId(issueShare.getID(), ShareHistoryItem.SharedItemType.ISSUE);
    }

    public int getCountCalls(FilterShare filterShare) {
        return this.shareHistoryManager.getCountCallsByShareId(filterShare.getID(), ShareHistoryItem.SharedItemType.FILTER);
    }

    public String getShareDomIdSuffix(IssueShare issueShare) {
        return "-issue-" + issueShare.getID();
    }

    public String getShareDomIdSuffix(FilterShare filterShare) {
        return "-filter-" + filterShare.getID();
    }

    public String getUrl(FilterShare filterShare) {
        return this.urlBuilder.buildUrl(filterShare);
    }

    public String getJiraDetailUrl(FilterShare filterShare) {
        return this.urlBuilder.buildJiraDetailUrl(filterShare);
    }

    public String getEditLinkUrl(IssueShare issueShare) {
        return "/plugins/servlet/shareYourJira/editIssueShareLink?id=" + issueShare.getID();
    }

    public String getEditLinkUrl(IssueShare issueShare, int share) {
        return "/plugins/servlet/shareYourJira/editIssueShareLink?id=" + issueShare.getID() + "&sendMail=" + share;
    }

    public String getEditLinkUrl(FilterShare filterShare) {
        return "/plugins/servlet/shareYourJira/editFilterShareLink?filterShareId=" + filterShare.getID();
    }

    public String getEditLinkUrl(FilterShare filterShare, int share) {
        return "/plugins/servlet/shareYourJira/editFilterShareLink?filterShareId=" + filterShare.getID() + "&sendMail=" + share;
    }

    public String getHistoryLinkUrl(IssueShare issueShare) {
        return "/plugins/servlet/shareYourJira/showIssueShareHistory?shareId=" + issueShare.getID();
    }

    public String getHistoryLinkUrl(FilterShare filterShare) {
        return "/plugins/servlet/shareYourJira/showFilterShareHistory?shareId=" + filterShare.getID();
    }

    public String getLinkData(IssueShare issueShare) {
        return " data-issue-share-id=\"" + issueShare.getID() + "\" ";
    }

    public String getLinkData(FilterShare filterShare) {
        return " data-filter-share-id=\"" + filterShare.getID() + "\" ";
    }

    public String getNote(ShareItem shareItem) {
        if (shareItem.getNote() != null) {
            return shareItem.getNote();
        }
        return "";
    }
}

