/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class EventManager {
    private final EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
    public static final String EVENT_TYPE_ISSUE_PUBLIC_SHARED = "Issue Public Shared";

    public EventType getEventTypeByName(String eventTypeName) {
        Collection eventTypes = this.eventTypeManager.getEventTypes();
        for (EventType eventType : eventTypes) {
            if (!eventType.getName().equals(eventTypeName)) continue;
            return eventType;
        }
        return null;
    }

    public void addEventType(String eventTypeName, String eventTypeDescription) {
        this.eventTypeManager.addEventType(new EventType(eventTypeName, eventTypeDescription, Long.valueOf(13L)));
    }

    public void fireIssueEvent(String eventTypeName, final Issue issue, final ApplicationUser user) {
        final EventType eventType = this.getEventTypeByName(eventTypeName);
        if (eventType == null) {
            return;
        }
        IssueEventBundle eventBundle = new IssueEventBundle(){

            public Collection<JiraIssueEvent> getEvents() {
                ArrayList<JiraIssueEvent> eventList = new ArrayList<JiraIssueEvent>();
                eventList.add((JiraIssueEvent)new DelegatingJiraIssueEvent(){

                    @Nonnull
                    public IssueEvent asIssueEvent() {
                        return new IssueEvent(issue, null, user, eventType.getId());
                    }
                });
                return eventList;
            }

            public boolean doesSendEmailNotification() {
                return true;
            }
        };
        ComponentAccessor.getIssueEventManager().dispatchEvent(eventBundle);
    }
}

