/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.common.ProjectManager;
import aptis.plugins.common.VisibilityOptionsManager;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CommentManager {
    private final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private final I18nResolver i18nResolver;
    private final VisibilityOptionsManager visibilityOptionsManager;
    public final String TYPE_ALL_USERS = "allUsers";
    public final String TYPE_SERVICE_DESK_INTERNAL = "serviceDeskInternal";
    public final String TYPE_PROJECT_ROLE = "projectRole";
    public final String TYPE_GROUP = "group";

    public CommentManager(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.visibilityOptionsManager = new VisibilityOptionsManager();
    }

    public List<Comment> getCommentsByIssue(Issue issue) {
        return ComponentAccessor.getCommentManager().getComments(issue);
    }

    public List<Comment> getVisibleComments(List<Comment> comments, List<String> visibilityOptions, ApplicationUser user) {
        if (visibilityOptions.size() == 0) {
            return new ArrayList<Comment>();
        }
        ArrayList<Comment> shownComments = new ArrayList<Comment>();
        for (Comment comment : comments) {
            if (!this.isVisible(comment, visibilityOptions, user)) continue;
            shownComments.add(comment);
        }
        return shownComments;
    }

    private boolean isVisible(Comment comment, List<String> visibilityOptions, ApplicationUser user) {
        if (comment.getIssue() == null || comment.getIssue().getProjectObject() == null) {
            return false;
        }
        Project project = comment.getIssue().getProjectObject();
        String projectTypeKey = project.getProjectTypeKey() == null ? "" : project.getProjectTypeKey().getKey();
        for (String visibilityOption : visibilityOptions) {
            String type = this.visibilityOptionsManager.getVisibilityOptionType(visibilityOption);
            String value = this.visibilityOptionsManager.getVisibilityOptionValue(visibilityOption);
            if (!(projectTypeKey.equals("service_desk") ? (type.equals("allUsers") ? !this.isInternalServiceDeskComment(comment, user) : type.equals("serviceDeskInternal") && this.isInternalServiceDeskComment(comment, user)) : (type.equals("allUsers") ? comment.getGroupLevel() == null && comment.getRoleLevelId() == null : (type.equals("group") ? comment.getGroupLevel() != null && comment.getGroupLevel().equals(value) : type.equals("projectRole") && comment.getRoleLevelId() != null && comment.getRoleLevelId().toString().equals(value))))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<String> getVisibilityOptions(Issue issue, ApplicationUser user) {
        ArrayList<String> visibilityOptions = new ArrayList<String>();
        visibilityOptions.add(this.visibilityOptionsManager.buildVisibilityOption("allUsers"));
        if (ProjectManager.isServiceDeskProject(issue.getProjectObject()).booleanValue()) {
            visibilityOptions.add(this.visibilityOptionsManager.buildVisibilityOption("serviceDeskInternal"));
        } else {
            List<String> groupsVisibilityOptions;
            List<String> projectRolesVisibilityOptions = this.getProjectRolesVisibilityOptions(user, issue.getProjectObject());
            if (projectRolesVisibilityOptions.size() > 0) {
                visibilityOptions.addAll(projectRolesVisibilityOptions);
            }
            if ((groupsVisibilityOptions = this.getGroupsVisibilityOptions(user)).size() > 0) {
                visibilityOptions.addAll(groupsVisibilityOptions);
            }
        }
        return visibilityOptions;
    }

    public JSONArray getVisibilityOptions(Issue issue) throws JSONException {
        ApplicationUser loggedInUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        JSONArray visibilityOptions = new JSONArray();
        visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("allUsers")).put("name", (Object)this.i18nResolver.getText("aptis-syj-visibility-option-all")));
        if (ProjectManager.isServiceDeskProject(issue.getProjectObject()).booleanValue()) {
            visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("serviceDeskInternal")).put("name", (Object)this.i18nResolver.getText("aptis-syj-visibility-option-service-desk")));
        } else {
            for (ProjectRole projectRole : ProjectManager.getRoles(loggedInUser, issue.getProjectObject())) {
                visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("projectRole", projectRole.getId().toString())).put("name", (Object)projectRole.getName()));
            }
            Collection groupsVisibilityOptions = this.groupManager.getGroupsForUser(loggedInUser);
            if (groupsVisibilityOptions.size() > 0) {
                for (Group group : groupsVisibilityOptions) {
                    visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("group", group.getName())).put("name", (Object)group.getName()));
                }
            }
        }
        return visibilityOptions;
    }

    private List<String> getProjectRolesVisibilityOptions(ApplicationUser user, Project project) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<ProjectRole> projectRoles = ProjectManager.getRoles(user, project);
        for (ProjectRole projectRole : projectRoles) {
            result.add(this.visibilityOptionsManager.buildVisibilityOption("projectRole", projectRole.getId().toString()));
        }
        return result;
    }

    private List<String> getGroupsVisibilityOptions(ApplicationUser user) {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.applicationProperties.getOption("jira.comment.level.visibility.groups")) {
            return result;
        }
        Collection groups = this.groupManager.getGroupsForUser(user);
        for (Group group : groups) {
            result.add(this.visibilityOptionsManager.buildVisibilityOption("group", group.getName()));
        }
        return result;
    }

    public String getDisplayText(String visibilityOption, Project project) {
        String type = this.visibilityOptionsManager.getVisibilityOptionType(visibilityOption);
        String value = this.visibilityOptionsManager.getVisibilityOptionValue(visibilityOption);
        if (type.equals("allUsers")) {
            if (project.getProjectTypeKey().getKey().equals("service_desk")) {
                return this.i18nResolver.getText("aptis-sjy-comment-visibility-service-desk-external");
            }
            return this.i18nResolver.getText("aptis-sjy-comment-visibility-all-users");
        }
        if (type.equals("serviceDeskInternal")) {
            return this.i18nResolver.getText("aptis-sjy-comment-visibility-service-desk-internal");
        }
        if (type.equals("group")) {
            Group group = this.groupManager.getGroup(value);
            if (group == null) {
                return value;
            }
            return group.getName();
        }
        if (type.equals("projectRole")) {
            ProjectRole projectRole = ProjectManager.getProjectRoleByName(Long.parseLong(value));
            if (projectRole == null) {
                return value;
            }
            return projectRole.getName();
        }
        return "";
    }

    private boolean isInternalServiceDeskComment(Comment comment, ApplicationUser user) {
        CommentPropertyService commentPropertyService = (CommentPropertyService)ComponentAccessor.getComponent(CommentPropertyService.class);
        EntityProperty commentProperty = (EntityProperty)commentPropertyService.getProperty(user, comment.getId(), "sd.public.comment").getEntityProperty().getOrNull();
        if (commentProperty == null) {
            return true;
        }
        try {
            String jsonString = commentProperty.getValue();
            JSONObject json = new JSONObject(jsonString);
            return json.getBoolean("internal");
        }
        catch (Exception exception) {
            return true;
        }
    }
}

