/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.common;

import aptis.plugins.common.VisibilityOptionsManager;
import aptis.plugins.shareYourJira.common.DownloadFileStreamConsumer;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class AttachmentManager {
    private final com.atlassian.jira.issue.AttachmentManager attachmentManager = ComponentAccessor.getAttachmentManager();
    private final I18nResolver i18nResolver;
    private final VisibilityOptionsManager visibilityOptionsManager;
    public final String TYPE_ALL = "all";
    public final String TYPE_SINGLE_ATTACHMENT = "singleAttachment";

    public AttachmentManager(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.visibilityOptionsManager = new VisibilityOptionsManager();
    }

    public void writeAttachmentToHttpServletResponse(HttpServletResponse response, Attachment attachment) throws Exception {
        response.setContentType(attachment.getMimetype());
        if (attachment.getFilesize() > Integer.MAX_VALUE) {
            throw new Exception(this.i18nResolver.getText("aptis-syj-max-file-size"));
        }
        Integer bytesTransferred = (Integer)this.attachmentManager.streamAttachmentContent(attachment, (InputStreamConsumer)new DownloadFileStreamConsumer(response));
        if (bytesTransferred == -1) {
            throw new Exception(this.i18nResolver.getText("aptis-syj-max-file-size"));
        }
    }

    public Attachment getAttachmentById(Long attachmentId) {
        return ComponentAccessor.getAttachmentManager().getAttachment(attachmentId);
    }

    public List<Attachment> getAttachmentsByIssue(Issue issue) {
        return this.attachmentManager.getAttachments(issue);
    }

    public List<Attachment> getVisibleAttachments(List<Attachment> attachments, List<String> visibilityOptions) {
        if (visibilityOptions.size() == 0) {
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> shownAttachments = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            if (!this.isVisible(attachment, visibilityOptions)) continue;
            shownAttachments.add(attachment);
        }
        return shownAttachments;
    }

    public boolean isVisible(Attachment attachment, List<String> visibilityOptions) {
        for (String visibilityOption : visibilityOptions) {
            String type = this.visibilityOptionsManager.getVisibilityOptionType(visibilityOption);
            String value = this.visibilityOptionsManager.getVisibilityOptionValue(visibilityOption);
            if (type.equals("all")) {
                return true;
            }
            if (!type.equals("singleAttachment") || !attachment.getId().toString().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<String> getVisibilityOptions(Issue issue, ApplicationUser user) {
        ArrayList<String> visibilityOptions = new ArrayList<String>();
        visibilityOptions.add(this.visibilityOptionsManager.buildVisibilityOption("all"));
        List attachments = this.attachmentManager.getAttachments(issue);
        for (Attachment attachment : attachments) {
            visibilityOptions.add(this.visibilityOptionsManager.buildVisibilityOption("singleAttachment", attachment.getId().toString()));
        }
        return visibilityOptions;
    }

    public JSONArray getVisibilityOptions(Issue issue) throws JSONException {
        JSONArray visibilityOptions = new JSONArray();
        visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("all")).put("name", (Object)this.i18nResolver.getText("aptis-syj-visibility-option-all")));
        List attachments = this.attachmentManager.getAttachments(issue);
        for (Attachment attachment : attachments) {
            visibilityOptions.put((Object)new JSONObject().put("id", (Object)this.visibilityOptionsManager.buildVisibilityOption("singleAttachment", attachment.getId().toString())).put("name", (Object)attachment.getFilename()));
        }
        return visibilityOptions;
    }

    public String getDisplayText(String visibilityOption) {
        String type = this.visibilityOptionsManager.getVisibilityOptionType(visibilityOption);
        String value = this.visibilityOptionsManager.getVisibilityOptionValue(visibilityOption);
        if (type.equals("all")) {
            return this.i18nResolver.getText("aptis-sjy-all-attachments");
        }
        if (type.equals("singleAttachment")) {
            Attachment attachment = this.attachmentManager.getAttachment(Long.valueOf(Long.parseLong(value)));
            if (attachment == null) {
                return value;
            }
            return attachment.getFilename();
        }
        return "";
    }
}

