/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.searchService;

import aptis.plugins.searchService.SearchServiceBridge;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchServiceBridge7
implements SearchServiceBridge {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @Override
    public List<Issue> search(Query query) {
        return this.search(query, ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser(), PagerFilter.getUnlimitedFilter());
    }

    @Override
    public List<Issue> search(Query query, ApplicationUser user) {
        return this.search(query, user, PagerFilter.getUnlimitedFilter());
    }

    @Override
    public List<Issue> search(Query query, PagerFilter<?> filter) {
        return this.search(query, ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser(), filter);
    }

    @Override
    public List<Issue> search(Query query, ApplicationUser user, PagerFilter<?> filter) {
        SearchService searchService = (SearchService)ComponentAccessor.getComponentOfType(SearchService.class);
        SearchResults results = null;
        try {
            results = searchService.search(user, query, filter);
        }
        catch (SearchException exception) {
            this.logger.error(exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (results != null) {
            return results.getIssues();
        }
        return new ArrayList<Issue>();
    }
}

