/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.common;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.util.Locale;

public class PluginLicenseValidator {
    private final PluginLicenseManager pluginLicenseManager;
    public final String LOCALE_ERROR_EN = "Invalid license: Your license of '{PLUGIN_NAME}' is expired. Please contact your admin to purchase a new license.";
    public final String LOCALE_ERROR_DE = "Ung\u00fcltige Lizenz: Ihre Lizenz von '{PLUGIN_NAME}' ist abgelaufen. Bitte kontaktieren Sie Ihren Administrator, um eine neue Lizenz zu erwerben.";

    public PluginLicenseValidator(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean hasValidLicense() {
        Option license = this.pluginLicenseManager.getLicense();
        if (!license.isDefined()) {
            return false;
        }
        return ((PluginLicense)license.get()).isValid();
    }

    public String getLocalizedErrorMessage(Locale locale) {
        String pluginName = "APTIS";
        Option license = this.pluginLicenseManager.getLicense();
        if (license.isDefined()) {
            pluginName = ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getPluginName();
        }
        if (locale != null && locale.getLanguage().equals(new Locale("de").getLanguage())) {
            return "Ung\u00fcltige Lizenz: Ihre Lizenz von '{PLUGIN_NAME}' ist abgelaufen. Bitte kontaktieren Sie Ihren Administrator, um eine neue Lizenz zu erwerben.".replace("{PLUGIN_NAME}", pluginName);
        }
        return "Invalid license: Your license of '{PLUGIN_NAME}' is expired. Please contact your admin to purchase a new license.".replace("{PLUGIN_NAME}", pluginName);
    }
}

