/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.common;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FieldRenderer {
    private final I18nResolver i18nResolver;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer templateRenderer;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public FieldRenderer(I18nResolver i18nResolver, TemplateRenderer templateRenderer, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.i18nResolver = i18nResolver;
        this.fieldManager = ComponentAccessor.getFieldManager();
        this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        this.applicationProperties = ComponentAccessor.getApplicationProperties();
        this.templateRenderer = templateRenderer;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public String renderValue(String fieldId, Issue issue, String token, int shareId) {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            if (this.fieldManager.isNavigableField(fieldId)) {
                NavigableField navigableField = this.fieldManager.getNavigableField(fieldId);
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(fieldId);
                return navigableField.getColumnViewHtml(fieldLayoutItem, context, issue);
            }
            return "";
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String renderAttachmentsField(List<Attachment> attachments, String token, int shareId) {
        try {
            if (attachments.size() == 0) {
                return "";
            }
            Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
            context.put("baseUrl", this.getBaseUrl());
            context.put("attachments", attachments);
            context.put("token", token);
            context.put("shareId", shareId);
            StringWriter writer = new StringWriter();
            this.templateRenderer.render("templates/common/attachmentField.vm", context, (Writer)writer);
            return writer.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String renderCommentsField(List<Comment> comments) {
        try {
            if (comments.size() == 0) {
                return "";
            }
            Collections.sort(comments, new Comparator<Comment>(){

                @Override
                public int compare(Comment comment1, Comment comment2) {
                    return comment1.getCreated().compareTo(comment2.getCreated());
                }
            });
            Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
            context.put("comments", comments);
            context.put("formatter", this.dateTimeFormatterFactory.formatter().forLoggedInUser());
            context.put("wikiRenderer", ComponentAccessor.getRendererManager().getRendererForType("atlassian-wiki-renderer"));
            StringWriter writer = new StringWriter();
            this.templateRenderer.render("templates/common/commentField.vm", context, (Writer)writer);
            return writer.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String renderName(String fieldId) {
        try {
            NavigableField field = ComponentAccessor.getFieldManager().getNavigableField(fieldId);
            return field.getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String renderName(String fieldId, Boolean shortenIfAllowed) {
        String name = this.renderName(fieldId);
        if (name.length() > 0 && shortenIfAllowed.booleanValue() && (fieldId.equals("issuetype") || fieldId.equals("priority"))) {
            name = name.substring(0, 1);
        }
        return name;
    }

    public String renderColumnName(String fieldId) {
        try {
            NavigableField field = ComponentAccessor.getFieldManager().getNavigableField(fieldId);
            return this.i18nResolver.getText(field.getColumnHeadingKey());
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getBaseUrl() {
        return this.applicationProperties.getString("jira.baseurl");
    }
}

