/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.common;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldProvider {
    private FieldManager fieldManager = null;

    public List<Field> getAllFieldsForIssueShare(I18nResolver i18nResolver) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        Set navigableFields = this.getFieldManager().getNavigableFields();
        for (Field field : navigableFields) {
            allFields.add(field);
        }
        Comparator<Field> comparator = new Comparator<Field>(){

            @Override
            public int compare(Field field1, Field field2) {
                return field1.getName().compareTo(field2.getName());
            }
        };
        Collections.sort(allFields, comparator);
        return allFields;
    }

    public Map<String, Field> getAllFieldsForFilterShare() {
        HashMap<String, Field> allFields = new HashMap<String, Field>();
        Set navigableFields = this.getFieldManager().getNavigableFields();
        for (Field field : navigableFields) {
            allFields.put(field.getId(), field);
        }
        return allFields;
    }

    private FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = ComponentAccessor.getFieldManager();
        }
        return this.fieldManager;
    }

    public List<Field> getFieldsByFieldIds(List<String> fieldIds, I18nResolver i18nResolver) {
        List<Field> allFields = this.getAllFieldsForIssueShare(i18nResolver);
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : allFields) {
            if (!fieldIds.contains(field.getId())) continue;
            result.add(field);
        }
        return result;
    }
}

