/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.common;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginInfoProvider;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class ErrorDetailProvider {
    private final Throwable exception;
    private final HttpServletRequest request;

    public ErrorDetailProvider(Throwable exception, HttpServletRequest request) {
        this.exception = exception;
        this.request = request;
    }

    public String getTechnicalDetails() {
        if (this.exception instanceof ExceptionWithoutTechnicalInformation) {
            return "";
        }
        StringBuilder technicalDetails = new StringBuilder("-----TECHNICAL INFORMATION START---\n");
        try {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            technicalDetails.append("Jira Version: ");
            technicalDetails.append(applicationProperties.getString("jira.version"));
            technicalDetails.append("\n");
            technicalDetails.append("Time: ");
            technicalDetails.append(new Date().toString());
            technicalDetails.append("\n");
        }
        catch (Exception applicationProperties) {
            // empty catch block
        }
        try {
            PluginInfoProvider pluginInfoProvider = new PluginInfoProvider();
            technicalDetails.append("Plugin-Key: ");
            technicalDetails.append(pluginInfoProvider.readKey());
            technicalDetails.append("\n");
            technicalDetails.append("Plugin-Version: ");
            technicalDetails.append(pluginInfoProvider.readVersion());
            technicalDetails.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            technicalDetails.append("JAVA-Version: ");
            technicalDetails.append(System.getProperty("java.version"));
            technicalDetails.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            technicalDetails.append("RequestURL: ");
            technicalDetails.append(this.request.getRequestURL().toString());
            technicalDetails.append("\n");
            technicalDetails.append("QueryString: ");
            technicalDetails.append(this.request.getQueryString());
            technicalDetails.append("\n");
            technicalDetails.append("RemoteUser: ");
            technicalDetails.append(this.request.getRemoteUser());
            technicalDetails.append("\n");
            technicalDetails.append("Locale: ");
            technicalDetails.append(this.request.getLocale().toString());
            technicalDetails.append("\n");
            technicalDetails.append("RemoteAddr: ");
            technicalDetails.append(this.request.getRemoteAddr());
            technicalDetails.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            technicalDetails.append("Exception-Class: ");
            technicalDetails.append(this.exception.getClass().toString());
            technicalDetails.append("\n");
            technicalDetails.append("\nStack Trace:\n");
            if (this.exception.getStackTrace() != null && this.exception.getStackTrace().length > 0) {
                for (StackTraceElement element : this.exception.getStackTrace()) {
                    technicalDetails.append("    ");
                    technicalDetails.append(element.toString());
                    technicalDetails.append("\n");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        technicalDetails.append("\n-----TECHNICAL INFORMATION END---");
        return technicalDetails.toString().replace("\n", "<br />");
    }
}

