/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.slf4j.Logger;

public abstract class AbstractMapVersionsPhase
extends AbstractReleasePhase {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;
    private final Prompter prompter;
    private final Map<String, VersionPolicy> versionPolicies;
    private final boolean convertToSnapshot;
    private final boolean convertToBranch;

    public AbstractMapVersionsPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, Prompter prompter, Map<String, VersionPolicy> versionPolicies, boolean convertToSnapshot, boolean convertToBranch) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
        this.prompter = Objects.requireNonNull(prompter);
        this.versionPolicies = Objects.requireNonNull(versionPolicies);
        this.convertToSnapshot = convertToSnapshot;
        this.convertToBranch = convertToBranch;
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        if (releaseDescriptor.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion())) {
            MavenProject project = rootProject;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String nextVersion = this.resolveNextVersion(project, projectId, releaseDescriptor, releaseEnvironment);
            if (!this.convertToSnapshot) {
                releaseDescriptor.addReleaseVersion(projectId, nextVersion);
            } else if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                releaseDescriptor.addReleaseVersion(projectId, nextVersion);
            } else {
                releaseDescriptor.addDevelopmentVersion(projectId, nextVersion);
            }
            for (MavenProject subProject : reactorProjects) {
                String subProjectNextVersion;
                String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                if (this.convertToSnapshot) {
                    subProjectNextVersion = releaseDescriptor.getProjectDevelopmentVersion(subProjectId);
                    String v = subProjectNextVersion != null ? subProjectNextVersion : (ArtifactUtils.isSnapshot((String)subProject.getVersion()) ? nextVersion : subProject.getVersion());
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.addReleaseVersion(subProjectId, v);
                        continue;
                    }
                    releaseDescriptor.addDevelopmentVersion(subProjectId, v);
                    continue;
                }
                subProjectNextVersion = releaseDescriptor.getProjectReleaseVersion(subProjectId);
                if (subProjectNextVersion != null) {
                    releaseDescriptor.addReleaseVersion(subProjectId, subProjectNextVersion);
                    continue;
                }
                releaseDescriptor.addReleaseVersion(subProjectId, nextVersion);
            }
        } else {
            for (MavenProject project : reactorProjects) {
                String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                String nextVersion = this.resolveNextVersion(project, projectId, releaseDescriptor, releaseEnvironment);
                if (!this.convertToSnapshot) {
                    releaseDescriptor.addReleaseVersion(projectId, nextVersion);
                    continue;
                }
                if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                    releaseDescriptor.addReleaseVersion(projectId, nextVersion);
                    continue;
                }
                releaseDescriptor.addDevelopmentVersion(projectId, nextVersion);
            }
        }
        result.setResultCode(0);
        return result;
    }

    private String resolveNextVersion(MavenProject project, String projectId, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws ReleaseExecutionException {
        String defaultVersion;
        if (this.convertToBranch) {
            if (!releaseDescriptor.isUpdateBranchVersions() || !ArtifactUtils.isSnapshot((String)project.getVersion()) && !releaseDescriptor.isUpdateVersionsToSnapshot()) {
                return project.getVersion();
            }
            defaultVersion = this.getReleaseVersion(projectId, releaseDescriptor);
        } else if (!this.convertToSnapshot) {
            defaultVersion = this.getReleaseVersion(projectId, releaseDescriptor);
        } else if (releaseDescriptor.isBranchCreation()) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion()) || !releaseDescriptor.isUpdateWorkingCopyVersions()) {
                return project.getVersion();
            }
            defaultVersion = this.getDevelopmentVersion(projectId, releaseDescriptor);
        } else {
            if (!releaseDescriptor.isUpdateWorkingCopyVersions()) {
                return project.getVersion();
            }
            defaultVersion = this.getDevelopmentVersion(projectId, releaseDescriptor);
        }
        String suggestedVersion = null;
        String nextVersion = defaultVersion;
        String messageFormat = null;
        try {
            while (nextVersion == null || ArtifactUtils.isSnapshot((String)nextVersion) != this.convertToSnapshot) {
                block24: {
                    if (suggestedVersion == null) {
                        String baseVersion = null;
                        if (this.convertToSnapshot) {
                            baseVersion = this.getReleaseVersion(projectId, releaseDescriptor);
                        }
                        if (baseVersion == null) {
                            baseVersion = project.getVersion();
                        }
                        try {
                            try {
                                suggestedVersion = this.resolveSuggestedVersion(baseVersion, releaseDescriptor, releaseEnvironment);
                            }
                            catch (VersionParseException e) {
                                if (releaseDescriptor.isInteractive()) {
                                    suggestedVersion = this.resolveSuggestedVersion("1.0", releaseDescriptor, releaseEnvironment);
                                    break block24;
                                }
                                throw new ReleaseExecutionException("Error parsing version, cannot determine next version: " + e.getMessage(), e);
                            }
                        }
                        catch (PolicyException | VersionParseException e) {
                            throw new ReleaseExecutionException(e.getMessage(), e);
                        }
                    }
                }
                if (releaseDescriptor.isInteractive()) {
                    if (messageFormat == null) {
                        messageFormat = "What is the " + this.getContextString(releaseDescriptor) + " version for \"%s\"? (" + MessageUtils.buffer().project("%s") + ")";
                    }
                    String message = String.format(messageFormat, project.getName(), project.getArtifactId());
                    nextVersion = this.prompter.prompt(message, suggestedVersion);
                    continue;
                }
                if (defaultVersion == null) {
                    nextVersion = suggestedVersion;
                    continue;
                }
                if (this.convertToSnapshot) {
                    throw new ReleaseExecutionException(defaultVersion + " is invalid, expected a snapshot");
                }
                throw new ReleaseExecutionException(defaultVersion + " is invalid, expected a non-snapshot");
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
        }
        return nextVersion;
    }

    private String getContextString(ReleaseDescriptor releaseDescriptor) {
        if (this.convertToBranch) {
            return "branch";
        }
        if (!this.convertToSnapshot) {
            return "release";
        }
        if (releaseDescriptor.isBranchCreation()) {
            return "new working copy";
        }
        return "new development";
    }

    private String resolveSuggestedVersion(String baseVersion, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws PolicyException, VersionParseException {
        VersionPolicyRequest request;
        VersionPolicy policy;
        block6: {
            String policyId = releaseDescriptor.getProjectVersionPolicyId();
            policy = this.versionPolicies.get(policyId);
            if (policy == null) {
                throw new PolicyException("Policy '" + policyId + "' is unknown, available: " + this.versionPolicies.keySet());
            }
            request = new VersionPolicyRequest().setVersion(baseVersion);
            if (releaseDescriptor.getProjectVersionPolicyConfig() != null) {
                request.setConfig(releaseDescriptor.getProjectVersionPolicyConfig().toString());
            }
            request.setWorkingDirectory(releaseDescriptor.getWorkingDirectory());
            if (this.scmRepositoryConfigurator != null && releaseDescriptor.getScmSourceUrl() != null) {
                try {
                    ScmRepository repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
                    ScmProvider provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
                    request.setScmRepository(repository);
                    request.setScmProvider(provider);
                }
                catch (NoSuchScmProviderException | ScmRepositoryException e) {
                    Logger logger = this.getLogger();
                    if (logger.isWarnEnabled()) {
                        logger.warn("Next Version will NOT be based on the version control: {}", (Object)e.getMessage());
                    }
                    if (!logger.isDebugEnabled()) break block6;
                    logger.warn("Next Version will NOT be based on the version control", (Throwable)e);
                }
            }
        }
        return this.convertToSnapshot ? policy.getDevelopmentVersion(request).getVersion() : policy.getReleaseVersion(request).getVersion();
    }

    private String getDevelopmentVersion(String projectId, ReleaseDescriptor releaseDescriptor) {
        String projectVersion = releaseDescriptor.getProjectDevelopmentVersion(projectId);
        if (projectVersion == null || projectVersion.isEmpty()) {
            projectVersion = releaseDescriptor.getDefaultDevelopmentVersion();
        }
        if (projectVersion == null || projectVersion.isEmpty()) {
            return null;
        }
        return projectVersion;
    }

    private String getReleaseVersion(String projectId, ReleaseDescriptor releaseDescriptor) {
        String projectVersion = releaseDescriptor.getProjectReleaseVersion(projectId);
        if (projectVersion == null || projectVersion.isEmpty()) {
            projectVersion = releaseDescriptor.getDefaultReleaseVersion();
        }
        if (projectVersion == null || projectVersion.isEmpty()) {
            return null;
        }
        return projectVersion;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }
}

