/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.executor;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteAgent;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class VersionVariableTask
implements TaskType,
DeploymentTaskType {
    public static final String VARIABLE_CONFIG_KEY = "variable";
    public static final String INCLUDE_GLOBAL_VARIABLE_CONFIG_KEY = "includeGlobals";
    public static final String OVERRIDE_BRANCH_VARIABLE = "branchVars";
    public static final String KEEP_CUSTOMISED_VARIABLE_CONFIG_KEY = "overrideCustomised";
    public static final String SCOPE_VARIABLE_CONFIG_KEY = "variableScope";

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        return this.executeTask((CommonTaskContext)taskContext);
    }

    @NotNull
    public TaskResult execute(@NotNull DeploymentTaskContext taskContext) throws TaskException {
        return this.executeTask((CommonTaskContext)taskContext);
    }

    public abstract TaskResult executeTask(CommonTaskContext var1) throws TaskException;

    public TaskResult skipUpdatingIfConflictWithCustomVariables(CommonTaskContext taskContext, String variableName) {
        taskContext.getBuildLogger().addBuildLogEntry("Variable: " + variableName + " already been given a customised value, skip updating");
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    String retrieveCurrentValue(String variableName, Map<String, String> buildCustomVariables, VariableContext variableContext, BuildLogger buildLogger) {
        if (buildCustomVariables.containsKey(variableName)) {
            return buildCustomVariables.get(variableName);
        }
        if (variableContext.getEffectiveVariables().containsKey(variableName)) {
            return ((VariableDefinitionContext)variableContext.getEffectiveVariables().get(variableName)).getValue();
        }
        buildLogger.addBuildLogEntry("Variable wasn't found in the Build context. It possibly doesn't exist. ");
        return "";
    }

    VariableUpdater.SaveStrategy retrieveStrategy(String variableName, boolean keepCustomised, VariableContext context) {
        VariableDefinitionContext variableContext = (VariableDefinitionContext)context.getEffectiveVariables().get(variableName);
        return keepCustomised && variableContext != null && variableContext.getVariableType() == VariableType.MANUAL ? VariableUpdater.SaveStrategy.SKIP : VariableUpdater.SaveStrategy.READ_SAVE;
    }

    boolean isRemote() {
        try {
            return RemoteAgent.getContext() != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

