/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater;

import com.atlassian.bamboo.plugins.variable.updater.BambooVersionAdvancer;
import com.atlassian.bamboo.plugins.variable.updater.MavenVersionAdvancer;
import com.atlassian.bamboo.plugins.variable.updater.RegexVersionAdvancer;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import java.util.regex.Pattern;
import org.apache.maven.shared.release.versions.VersionParseException;

public class VersionAdvancer {
    public String advanceVariable(VariableUpdater.IncrementStrategy strategy, String value, String regex) throws VersionParseException {
        String newValue;
        switch (strategy) {
            case MAVENRELEASE: {
                newValue = new MavenVersionAdvancer().advance(value);
                break;
            }
            case REGEX: {
                newValue = new RegexVersionAdvancer().advance(value, Pattern.compile(regex));
                break;
            }
            case DEPLOYMENT: {
                newValue = new BambooVersionAdvancer().advance(value);
                break;
            }
            case NONE: {
                newValue = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return newValue;
    }
}

