/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater;

class BambooVersionAdvancer {
    BambooVersionAdvancer() {
    }

    public String advance(String version) {
        char[] originalChars = version.toCharArray();
        boolean inVariable = false;
        boolean inNumber = false;
        int numberEndIndex = -1;
        int numberStartIndex = 0;
        for (int i = originalChars.length - 1; i >= 0; --i) {
            char c = originalChars[i];
            if (c >= '0' && c <= '9') {
                if (inVariable || inNumber) continue;
                inNumber = true;
                numberEndIndex = i;
                continue;
            }
            if (inNumber) {
                numberStartIndex = i + 1;
                break;
            }
            if (c == '}') {
                inVariable = true;
                continue;
            }
            if (c != '{') continue;
            inVariable = false;
        }
        if (numberEndIndex >= 0) {
            String oldVersionNumber = version.substring(numberStartIndex, numberEndIndex + 1);
            long numberToIncrement = Long.parseLong(oldVersionNumber);
            StringBuilder newString = new StringBuilder();
            newString.append(version.substring(0, numberStartIndex));
            newString.append(++numberToIncrement);
            newString.append(version.substring(numberEndIndex + 1));
            return newString.toString();
        }
        return version;
    }
}

