/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetParameterUtils {
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private static final Logger log = LoggerFactory.getLogger(TargetParameterUtils.class);

    public static TargetParameterUtils getInstance(HostApp hostApp, KerbConfManager kerbConfManager) {
        return new TargetParameterUtils(hostApp, kerbConfManager);
    }

    private TargetParameterUtils(HostApp hostApp, KerbConfManager kerbConfManager) {
        this.hostApp = hostApp;
        this.kerbConfManager = kerbConfManager;
    }

    public String extractTargetParameter(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return "";
        }
        if (StringUtils.containsNone((CharSequence)queryString, (String)"=")) {
            queryString = HttpUrlUtils.softUrlDecode((String)queryString);
        }
        try {
            HashSet<String> targetParams = new HashSet<String>(Arrays.asList(this.hostApp.getTargetUrlParameters()));
            Set<String> configuredParams = this.kerbConfManager.getConfiguredTargetUrlParameters();
            String target = "";
            ArrayList<String> targetUrlParameters = new ArrayList<String>();
            for (String urlParameter : queryString.split("&")) {
                String paramValue;
                String[] parts = urlParameter.split("=", 2);
                String paramName = parts[0];
                String string = paramValue = parts.length > 1 ? parts[1] : "";
                if (targetParams.contains(paramName)) {
                    target = paramValue;
                    continue;
                }
                if (!configuredParams.contains(paramName)) continue;
                targetUrlParameters.add(urlParameter);
            }
            String urlParameters = String.join((CharSequence)"&", targetUrlParameters);
            Object targetWithParameters = StringUtils.isBlank((CharSequence)target) ? "" : (targetUrlParameters.isEmpty() ? target : (target.contains("?") ? target + "&" + urlParameters : target + "?" + urlParameters));
            log.debug("Target with url parameters {} generated from querystring {}", targetWithParameters, (Object)queryString);
            return targetWithParameters;
        }
        catch (Exception e) {
            log.warn("Failed to extract target parameter from query string: {}", (Object)queryString, (Object)e);
            return "";
        }
    }

    public static String extractAndDecodeTargetParameter(HttpServletRequestFacade request, HostApp hostApp, KerbConfManager kerbConfManager) {
        String potentiallyUrlEncodedUrl = TargetParameterUtils.extractPotentiallyEncodedTargetParameter(request, hostApp, kerbConfManager);
        String urlDecoded = HttpUrlUtils.softUrlDecode((String)potentiallyUrlEncodedUrl);
        return HttpUrlUtils.turnConsecutiveSlashesIntoSingleSlash((String)urlDecoded);
    }

    private static String extractPotentiallyEncodedTargetParameter(HttpServletRequestFacade request, HostApp hostApp, KerbConfManager kerbConfManager) {
        String baseUrl = HttpUrlUtils.extractRequestBaseUrlWithContextPath((HttpServletRequestFacade)request);
        String target = TargetParameterUtils.getInstance(hostApp, kerbConfManager).extractTargetParameter(request.getQueryString());
        if (StringUtils.isBlank((CharSequence)target)) {
            return "";
        }
        if (target.startsWith(baseUrl)) {
            return target;
        }
        if (HttpUrlUtils.softUrlDecode((String)target).startsWith(baseUrl)) {
            return target;
        }
        return baseUrl + "/" + target;
    }
}

