/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.kantega.atlaskerb.KerbConfManager;

public class AESCrypto {
    private static final int IV_LENGTH = 12;
    private static final int AUTHENTICATION_TAG_LENGTH = 128;
    private static final int KEY_SIZE = 16;

    private static SecretKey generateKey(String password) throws Exception {
        byte[] key = password.getBytes(StandardCharsets.UTF_8);
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        return new SecretKeySpec(key, "AES");
    }

    public static String encrypt(String data, String password) throws Exception {
        SecretKey key = AESCrypto.generateKey(password);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] iv = new byte[12];
        KerbConfManager.SECURE_RANDOM.nextBytes(iv);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)key, spec);
        byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedIVAndText = new byte[iv.length + encrypted.length];
        System.arraycopy(iv, 0, encryptedIVAndText, 0, iv.length);
        System.arraycopy(encrypted, 0, encryptedIVAndText, iv.length, encrypted.length);
        return Base64.getEncoder().encodeToString(encryptedIVAndText);
    }

    public static String decrypt(String encryptedData, String password) throws Exception {
        SecretKey key = AESCrypto.generateKey(password);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] decoded = Base64.getDecoder().decode(encryptedData);
        byte[] iv = Arrays.copyOfRange(decoded, 0, 12);
        byte[] encryptedBytes = Arrays.copyOfRange(decoded, 12, decoded.length);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)key, spec);
        byte[] decrypted = cipher.doFinal(encryptedBytes);
        return new String(decrypted, StandardCharsets.UTF_8);
    }
}

