/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.collection.List;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.upgrade.data.UpgradeResult;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStatusServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigStatusServlet.class);
    private final TemplateRenderer renderer;
    private final KerbConfManager kerbConfManager;
    private final KssoUpgradeManager kssoUpgradeManager;

    @Inject
    public ConfigStatusServlet(RequireAdminServletDependencyBucket bucket, KssoUpgradeManager kssoUpgradeManager) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.kssoUpgradeManager = kssoUpgradeManager;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        boolean doUpdate = StringUtils.equals((CharSequence)"doUpgrade", (CharSequence)req.getParameter("action"));
        boolean confirmVersionChange = StringUtils.equals((CharSequence)"confirmVersionChange", (CharSequence)req.getParameter("action"));
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        String savedVersion = (String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull();
        if (doUpdate) {
            try {
                List messages = List.ofAll(this.kssoUpgradeManager.doUpgrade());
                if (messages.forAll(UpgradeMessage::isSuccess)) {
                    additionalData.put("runningKssoVersion", KerbConfManager.getRunningKssoVersion().stringValue);
                    additionalData.put("updatedFrom", savedVersion);
                    List updateResults = messages.flatMap(UpgradeMessage::getUpdateResults).distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageUrl(), (CharSequence)b.getConfigPageUrl()) ? 0 : 1);
                    additionalData.put("updateSuccessResults", updateResults.toJavaList());
                } else if (messages.exists(msg -> msg.getResultCode() == KssoUpgradeManager.ResultCode.VERSION_CHANGE_FAILURE)) {
                    additionalData.put("versionChangeFailure", true);
                } else {
                    List updateResults = messages.filter(UpgradeMessage::isFailure).flatMap(message -> message.getUpdateResults().filter(UpgradeResult::isFailure)).distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1);
                    additionalData.put("upgradeFailedResults", updateResults.toJavaList());
                    additionalData.put("upgradeFailed", true);
                    additionalData.put("messagesWithPageUri", messages.filter(UpgradeMessage::isFailure).filter(updateMessage -> StringUtils.isNotBlank((CharSequence)updateMessage.getConfigPageUri())));
                }
                additionalData.put("updateMessage", messages.map(UpgradeMessage::getMessage).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            }
            catch (Exception e) {
                log.error("Encountered an unexpected error during upgrade of Kantega SSO Configuration:", (Throwable)e);
                throw new RuntimeException("Encountered an unexpected error during upgrade of Kantega SSO Configuration. Please re-try and contact support if the issue persists.", e);
            }
        } else if (confirmVersionChange) {
            try {
                this.kerbConfManager.upgradeKssoVersionInConfig();
            }
            catch (Exception e) {
                additionalData.put("persistentVersionError", true);
            }
        } else if ("resetConfigVersion".equals(req.getParameter("action"))) {
            this.kerbConfManager.setKssoConfigVersion(KerbConfManager.getRunningKssoVersion());
        }
        this.buildModelAndRenderTemplate(req, resp, additionalData);
    }

    private void buildModelAndRenderTemplate(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.newModel(req);
        boolean isConfigUpgradeNeeded = this.kssoUpgradeManager.isKssoConfigUpgradeNeeded();
        model.putAll(additionalData);
        model.putIfAbsent("updateOk", !isConfigUpgradeNeeded && !this.kssoUpgradeManager.hasBadVersionUpgrade() && !this.kssoUpgradeManager.hasUpgradeFailures());
        model.putIfAbsent("needsUpgradeOrUpgradeFailed", isConfigUpgradeNeeded || this.kssoUpgradeManager.hasUpgradeFailures());
        if (this.kssoUpgradeManager.hasBadVersionUpgrade()) {
            model.put("hasBadVersionUpgrade", true);
            model.put("recommendedVersion", this.kssoUpgradeManager.recommendedVersionOnBadUpgrade().stringValue);
        }
        model.put("isBreakingVersionDowngrade", this.kssoUpgradeManager.isBreakingVersionDowngrade());
        model.put("savedConfigVersion", this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull());
        model.put("runningKssoVersion", KerbConfManager.getRunningKssoVersion().stringValue);
        model.putIfAbsent("upgradeFailedResults", this.kssoUpgradeManager.getUpgradeFailures().distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1).asJava());
        model.putIfAbsent("upgradeFailed", this.kssoUpgradeManager.hasUpgradeFailures());
        List messagesWithPageUri = this.kssoUpgradeManager.getUpgradeFailures().distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1);
        model.put("menuItem", "configStatus");
        File homeDirectory = this.hostApp.getHomeDirectory();
        File backupsDirectory = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_snapshots");
        boolean ignored = backupsDirectory.mkdirs();
        model.put("backupDirectoryExists", backupsDirectory.exists());
        model.put("backupDirectoryReadable", backupsDirectory.canRead());
        model.put("backupDirectoryWritable", backupsDirectory.canWrite());
        model.put("backupDirectoryExecutable", backupsDirectory.canExecute());
        model.put("path", this.kerbConfManager.getHomeDirectoryResolver().getHomeDirectory().toPath());
        model.put("topMenu", "dashboard");
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/config-status.vm", model, (Writer)resp.getWriter());
    }
}

