/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim;

import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.ksso.scim.atlassian.hostapp.BambooScimHostApp;
import com.ksso.scim.atlassian.hostapp.BitbucketScimHostApp;
import com.ksso.scim.atlassian.hostapp.ConfluenceScimHostApp;
import com.ksso.scim.atlassian.hostapp.ScimHostApp;
import com.ksso.scim.atlassian.hostapp.ScimJiraHostApp;

public class ScimHostAppFactory {
    private final ScimHostApp hostApp;

    public ScimHostAppFactory(ApplicationProperties applicationProperties, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        String dn = applicationProperties.getDisplayName().toLowerCase();
        if (dn.contains("jira")) {
            this.hostApp = new ScimJiraHostApp(directoryManager, applicationManager, applicationProperties);
        } else if (dn.contains("confluence")) {
            this.hostApp = new ConfluenceScimHostApp(directoryManager, applicationManager, applicationProperties);
        } else if (dn.contains("bitbucket")) {
            this.hostApp = new BitbucketScimHostApp(directoryManager, applicationManager, applicationProperties);
        } else if (dn.contains("bamboo")) {
            this.hostApp = new BambooScimHostApp(directoryManager, applicationManager, applicationProperties);
        } else {
            throw new IllegalStateException("SCIM does not work on " + applicationProperties.getDisplayName());
        }
    }

    public ScimHostAppFactory(ScimHostApp hostApp) {
        this.hostApp = hostApp;
    }

    public ScimHostApp getHostApp() {
        return this.hostApp;
    }
}

