/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@UnrestrictedAccess
public class UserTestServlet
extends HttpServletFacade {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;

    @Inject
    public UserTestServlet(@ComponentImport TemplateRenderer renderer, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport UserManager userManager, IdpConfManager idpConfManager, HostAppFactory hostAppFactory) {
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
    }

    @UnrestrictedAccess
    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String requestURI = req.getRequestURI();
        String idpId = requestURI.substring(requestURI.lastIndexOf("/sp/") + "/sp/".length(), requestURI.lastIndexOf("/"));
        IdpConfiguration idpConfiguration = this.idpConfManager.getIdentityProviderById(idpId);
        IdpConfiguration.SSOProtocol ssoProtocol = idpConfiguration.getProtocol();
        boolean isRunTest = Option.of((Object)req.getParameter("runtest")).isDefined();
        boolean isAck = Option.of((Object)req.getParameter("ack")).isDefined();
        String unsafeTestId = req.getParameter("testID");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setContentType("text/html");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("added", req.getParameter("added") != null);
        model.put("idp", idpConfiguration);
        model.put("ssoProtocol", (Object)ssoProtocol);
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        model.put("runtest", isRunTest);
        model.put("added", req.getParameter("added") != null);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("isSystemAdmin", HttpUrlUtils.isSystemAdmin((UserManager)this.userManager, (HttpServletRequestFacade)req));
        model.put("ack", isAck);
        model.put("testID", unsafeTestId);
        boolean smtpSupported = this.hostApp.isSMTPSupported();
        model.put("mailSupported", smtpSupported);
        if (smtpSupported) {
            model.put("mailServerDefined", this.hostApp.isSMTPEnabled());
        }
        model.put("mailSettingsAction", this.idpConfManager.getServiceProviderTestUrl(req, idpId));
        model.put("krb_token", req.getSessionKsso().getAttribute("krb_csrf_token"));
        model.put("testResultsURL", this.idpConfManager.getServiceProviderTestUrl(req, idpId));
        model.put("overviewUrl", this.idpConfManager.getProviderOverviewUrl(req, idpId));
        model.put("shareURL", this.idpConfManager.getServiceProviderNonAdminTestUrl(req, idpId));
        model.put("testURL", "login?test");
        model.put("is_logged_in", this.hostApp.isLoggedIn(req));
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        this.renderer.render("templates/idp-login-test/idp-login-test.vm", model, (Writer)resp.getWriter());
    }
}

