/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.enums.GroupComparisonType;
import org.kantega.atlaskerb.identityproviders.enums.GroupRuleEvalutationResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.JitGroupRule;

public class IdpJITGroupServlet
extends RequireAdminServlet {
    private IdpConfiguration configuration;

    public IdpJITGroupServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String requestId = IdpConfManager.IdpServletUtil.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(requestId);
        Map<String, Object> model = this.newModel(req);
        List<JitGroupRule> groupRules = this.configuration.getAdvancedGroupRules();
        groupRules.sort(Comparator.comparing(JitGroupRule::getPriority));
        model.put("advancedJitRules", groupRules);
        this.renderPage(req, resp, model);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String idpId = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(previousConf);
        String addAutoGroup = req.getParameter("addAutoGroup");
        String removeAutoGroup = req.getParameter("removeAutoGroup");
        if (req.getParameter("setAutoCreateUserPolicy") != null) {
            IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy = (IdpConfiguration.AutoCreateUserPolicy)((Object)Option.of((Object)req.getParameter("autoCreateUserPolicy")).toTry().mapTry(IdpConfiguration.AutoCreateUserPolicy::valueOf).getOrElse((Object)IdpConfiguration.AutoCreateUserPolicy.ALWAYS));
            builder.setAutoCreateUserPolicy(autoCreateUserPolicy);
        }
        if (addAutoGroup != null) {
            autoGroup = new ManagedGroup(addAutoGroup);
            builder.getAutoGroups().add(autoGroup);
        } else if (removeAutoGroup != null) {
            autoGroup = new ManagedGroup(removeAutoGroup);
            builder.getAutoGroups().remove(autoGroup);
        }
        this.handleAdvancedRules(req, builder);
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        resp.sendRedirect("jit-group");
    }

    private void handleAdvancedRules(HttpServletRequestFacade req, IdpConfigurationBuilder<?, ?> builder) {
        String action = req.getParameter("advancedGroupRuleAction");
        String ruleId = req.getParameter("advancedGroupRuleId");
        String value = req.getParameter("advancedGroupRuleValue");
        if (action != null) {
            List<JitGroupRule> rules = builder.getAdvancedGroupJitRules();
            JitGroupRule rule = null;
            if (ruleId != null && !ruleId.isEmpty()) {
                rule = rules.stream().filter(e -> e.getId() == Integer.parseInt(ruleId)).findFirst().get();
            }
            switch (action) {
                case "addRule": {
                    int nextId = builder.getAdvancedGroupJitRules().stream().max(Comparator.comparing(JitGroupRule::getId)).map(e -> e.getId()).orElse(0) + 1;
                    JitGroupRule newRule = new JitGroupRule(nextId);
                    newRule.setPriority(builder.getAdvancedGroupJitRules().size() + 1);
                    builder.getAdvancedGroupJitRules().add(newRule);
                    break;
                }
                case "removeRule": {
                    builder.getAdvancedGroupJitRules().remove(rule);
                    break;
                }
                case "addGroup": {
                    rule.getGroups().add(value);
                    break;
                }
                case "removeGroup": {
                    rule.getGroups().remove(value);
                    break;
                }
                case "setGroups": {
                    rule.setGroups(new HashSet<String>(Arrays.asList(value.split(","))));
                    break;
                }
                case "setComparisonType": {
                    rule.setComparisonType(GroupComparisonType.valueOf(value));
                    break;
                }
                case "setRuleResult": {
                    rule.setResult(GroupRuleEvalutationResult.valueOf(value));
                    break;
                }
                case "increasePriority": {
                    this.setNewRulePriorities(rules, rule, true);
                    break;
                }
                case "decreasePriority": {
                    this.setNewRulePriorities(rules, rule, false);
                    break;
                }
                case "toggleEnabled": {
                    rule.setEnabled(!rule.isEnabled());
                    break;
                }
            }
        }
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        model.put("idp", this.configuration);
        model.put("userNotFoundPolicy", (Object)this.configuration.getUserNotFoundPolicy());
        model.put("userActivatePolicy", (Object)this.configuration.getUserActivatePolicy());
        model.put("autoCreateUserPolicy", (Object)this.configuration.getAutoCreateUserPolicy());
        model.put("topMenu", "SAML");
        model.put("menuItem", "jit-group");
        this.getTemplateRenderer().render("templates/saml/idp-jit-group.vm", model, (Writer)resp.getWriter());
    }

    private void setNewRulePriorities(List<JitGroupRule> rules, JitGroupRule rule, boolean increase) {
        if (rules == null || rule == null || rules.isEmpty()) {
            return;
        }
        int currentPriority = rule.getPriority();
        int maxPriority = rules.stream().mapToInt(JitGroupRule::getPriority).max().orElse(currentPriority);
        int minPriority = rules.stream().mapToInt(JitGroupRule::getPriority).min().orElse(currentPriority);
        if (increase) {
            if (currentPriority > maxPriority) {
                return;
            }
            int newPriority = currentPriority - 1;
            for (JitGroupRule other : rules) {
                if (other.getId() == rule.getId() || other.getPriority() != newPriority) continue;
                other.setPriority(currentPriority);
                break;
            }
            rule.setPriority(newPriority);
        } else {
            if (currentPriority < minPriority) {
                return;
            }
            int newPriority = currentPriority + 1;
            for (JitGroupRule other : rules) {
                if (other.getId() == rule.getId() || other.getPriority() != newPriority) continue;
                other.setPriority(currentPriority);
                break;
            }
            rule.setPriority(newPriority);
        }
    }
}

