/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogout;
import org.kantega.atlaskerb.identityproviders.oidc.OidcFactory;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.samllib.SpLogoutServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class AtlSpLogoutServlet
extends SpLogoutServlet {
    private static final Logger log = LoggerFactory.getLogger(AtlSpLogoutServlet.class);
    private static final String PATH_POSTFIX = "/logout";
    private static final String PATH_PREFIX = "/plugins/servlet/no.kantega.saml/sp/";
    private static final String PARAM_ACTION = "action";
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final AtlSpServletSupport atlSpServletSupport;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final OidcLibWrapper oidcLibWrapper;

    @Inject
    public AtlSpLogoutServlet(@ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostApp, AtlSpServletSupport atlSpServletSupport, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory, JsonWrapper jsonWrapper, OidcFactory oidcFactory) {
        this.applicationProperties = applicationProperties;
        this.hostApp = hostApp.getInstance();
        this.atlSpServletSupport = atlSpServletSupport;
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.oidcLibWrapper = oidcFactory.createOidcLibWrapper(jsonWrapper);
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Optional maybeIdpConfig = AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getIdpConfig);
        if (!maybeIdpConfig.isPresent()) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            IdpConfiguration idpConfig = (IdpConfiguration)maybeIdpConfig.get();
            if (idpConfig.isOidc()) {
                OidcIdpConfiguration oidcConfig = (OidcIdpConfiguration)idpConfig;
                this.performOidcSingleLogout(req, resp, oidcConfig);
            } else if (idpConfig.isSaml()) {
                this.performSamlSingleLogout(req, resp);
            } else {
                throw new RuntimeException("Does not recognize the identity provider type.");
            }
        }
    }

    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (!this.checkExists(req)) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            super.doPostKsso(req, resp);
        }
    }

    protected ServiceProviderSpi getServiceProviderSpi(HttpServletRequestFacade req) {
        return AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getServiceProviderSpi).orElse(null);
    }

    private boolean checkExists(HttpServletRequestFacade req) {
        return this.getServiceProviderSpi(req) != null;
    }

    private void performOidcSingleLogout(HttpServletRequestFacade req, HttpServletResponseFacade resp, OidcIdpConfiguration oidcConf) throws IOException {
        HttpSessionFacade session = req.getSessionKsso(false);
        if (session == null) {
            log.warn("Session is null, unable to invalidate session during OIDC logout");
        } else {
            String idTokenSessionFromSession = (String)session.getAttribute("ksso.oidc.idtoken");
            this.hostApp.invalidateSession(resp, req);
            this.hostApp.deleteIdpSessionDataCookie(req, resp);
            String IDP_SLO_DONE = "idp_slo_done";
            if (!"idp_slo_done".equals(req.getParameter(PARAM_ACTION))) {
                resp.sendRedirect(InitiateOidcLogout.run(oidcConf, this.applicationProperties, this.oidcLibWrapper, this.hostApp, idTokenSessionFromSession, req.getRequestURL().toString() + "?action=idp_slo_done"));
                return;
            }
        }
        String defaultReturnUrl = HttpUrlUtils.extractRequestBaseUrlWithContextPath((HttpServletRequestFacade)req) + this.logoutAppHelper.getDefaultLogoutReturnUrl(req, resp, SingleLogoutAppHelper.Protocol.OIDC);
        resp.sendRedirect(defaultReturnUrl);
    }

    private void performSamlSingleLogout(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if ("init".equals(req.getParameter(PARAM_ACTION)) && !this.logoutAppHelper.optionallyValidateXsrfToken(req, resp)) {
            log.debug("Invalid XSRF token, aborting");
            this.atlSpServletSupport.renderNotFound(req, resp);
            return;
        }
        this.logoutAppHelper.getIdpSessionIdFromCookieAndSetInSession(req, resp);
        super.doGetKsso(req, resp);
        this.hostApp.deleteIdpSessionDataCookie(req, resp);
    }
}

