/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import io.vavr.control.Option;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.identityproviders.model.AssignGroupRule;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.saml.util.JitGroupRule;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public class SamlIdpConfiguration
extends IdpConfiguration {
    public static final String SAML_SESSION_IDENTIFICATION = "ksso.saml.session.identification";
    public static final String DEFAULT_AUTHN_CONTEXT_CLASS_REF = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
    private final String idpURL;
    private final List<byte[]> signingCerts;
    private final boolean encryptedAssertionsRequired;
    private final boolean instantLoginUrlInSession;
    private final boolean usePostBinding;
    private final String metadataURL;
    private final String singleLogoutServiceURL;
    private final RequestedAuthnContextPolicy requestedAuthnContextPolicy;
    private final RequestedAuthnContextComparison requestedAuthnContextComparison;
    private final String authnContextClassRef;
    private final IssuerPolicy issuerPolicy;
    private final String issuer;
    private final IdpConfiguration.AllowCreate allowCreate;
    private final IdpConfiguration.NameIdFormat nameIdFormat;
    private final String customNameIdFormat;
    private final SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy;
    private final boolean autoRefreshMetadataEnabled;

    public SamlIdpConfiguration(boolean mfaRequired, String mfaAttribute, IdpConfiguration.AllowCreate allowCreate, Set<AssignGroupRule> assignGroupRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, boolean enabled, String id, Optional<Long> jitDirectory, IdpConfiguration.Kind kind, LinkedHashSet<String> knownDomains, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, List<ManagedGroup> autoGroups, List<JitGroupRule> advancedGroupRules, boolean managedGroupsRequiredForJITCreation, String name, String notificationEmails, List<Pair<String, String>> userTransformationRegexes, List<Pair<UsernameAttribute, String>> usernameAttributePriority, boolean singleLogoutEnabled, IdpConfiguration.UserActivatePolicy userActivatePolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, IdpConfiguration.UsernamePolicy usernamePolicy, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy, IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy, IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy, boolean hostedDomain, Set<String> idpGroupsAttribute, Map<String, String> userProfileKeyTransformations, boolean authenticatedAnonymousBrowsingEnabled, String tlsFingerprint, int idpPriority, int loginPageDisplayOrder, String authnContextClassRef, String customNameIdFormat, boolean encryptedAssertionsRequired, boolean instantLoginUrlInSession, boolean usePostBinding, String idpURL, String issuer, IssuerPolicy issuerPolicy, String metadataURL, IdpConfiguration.NameIdFormat nameIdFormat, SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy, List<byte[]> signingCerts, String singleLogoutServiceURL, String singleLogoutReturnURL, RequestedAuthnContextComparison requestedAuthnContextComparison, RequestedAuthnContextPolicy requestedAuthnContextPolicy, boolean autoRefreshMetadataEnabled, RedirectProperties redirectProperties, RedirectProperties jsmRedirectProperties, JSONArray storedUserAttributes, boolean removeUnusedUserAttributes) {
        super(mfaRequired, mfaAttribute, assignGroupRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, enabled, id, jitDirectory, kind, knownDomains, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, autoGroups, advancedGroupRules, managedGroupsRequiredForJITCreation, name, notificationEmails, userTransformationRegexes, usernameAttributePriority, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernamePolicy, userNotFoundPolicy, userUpdateNamePolicy, userUpdateEmailPolicy, autoCreateUserPolicy, hostedDomain, idpGroupsAttribute, singleLogoutReturnURL, userProfileKeyTransformations, authenticatedAnonymousBrowsingEnabled, redirectProperties, jsmRedirectProperties, tlsFingerprint, idpPriority, loginPageDisplayOrder, storedUserAttributes, removeUnusedUserAttributes);
        this.idpURL = idpURL;
        this.signingCerts = signingCerts;
        this.encryptedAssertionsRequired = encryptedAssertionsRequired;
        this.instantLoginUrlInSession = instantLoginUrlInSession;
        this.usePostBinding = usePostBinding;
        this.metadataURL = metadataURL;
        this.singleLogoutServiceURL = singleLogoutServiceURL;
        this.sessionIdentificationValidationPolicy = sessionIdentificationValidationPolicy;
        this.requestedAuthnContextPolicy = requestedAuthnContextPolicy;
        this.requestedAuthnContextComparison = requestedAuthnContextComparison;
        this.authnContextClassRef = authnContextClassRef;
        this.issuerPolicy = issuerPolicy;
        this.issuer = issuer;
        this.nameIdFormat = nameIdFormat;
        this.customNameIdFormat = customNameIdFormat;
        this.allowCreate = allowCreate;
        this.autoRefreshMetadataEnabled = autoRefreshMetadataEnabled;
    }

    @Override
    public IdpConfiguration.SSOProtocol getProtocol() {
        return IdpConfiguration.SSOProtocol.SAML;
    }

    public IssuerPolicy getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIdpURL() {
        return this.idpURL;
    }

    public String getMetadataUrl() {
        return this.metadataURL;
    }

    public String getSingleLogoutServiceURL() {
        return this.singleLogoutServiceURL;
    }

    public boolean supportForceAuthn() {
        return this.getIdpURL() != null && this.getIdpURL().contains("/adfs/ls");
    }

    public List<byte[]> getSigningCerts() {
        return this.signingCerts;
    }

    public RequestedAuthnContextPolicy getRequestedAuthnContextPolicy() {
        return this.requestedAuthnContextPolicy;
    }

    public RequestedAuthnContextComparison getRequestedAuthnContextComparison() {
        return this.requestedAuthnContextComparison;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public IdpConfiguration.NameIdFormat getNameIdFormat() {
        return this.nameIdFormat;
    }

    public String getCustomNameIdFormat() {
        return this.customNameIdFormat;
    }

    public boolean isEncryptedAssertionsRequired() {
        return this.encryptedAssertionsRequired;
    }

    public boolean isInstantLoginUrlInSession() {
        return this.instantLoginUrlInSession;
    }

    public boolean isUsePostBinding() {
        return this.usePostBinding;
    }

    public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
        return this.sessionIdentificationValidationPolicy;
    }

    public IdpConfiguration.AllowCreate getAllowCreate() {
        return this.allowCreate;
    }

    public boolean isAutoRefreshMetadataEnabled() {
        return this.autoRefreshMetadataEnabled;
    }

    @Override
    public boolean isOidc() {
        return false;
    }

    @Override
    public boolean isSaml() {
        return true;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = super.asJson();
        json.put("idpURL", (Object)this.getIdpURL());
        json.put("signingCerts", (Object)new JSONArray((Collection)io.vavr.collection.List.ofAll(this.getSigningCerts()).map(bytes -> {
            X509Certificate cert = CertTool.parse(bytes);
            JSONObject certJson = new JSONObject();
            certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
            certJson.put("notBefore", (Object)cert.getNotBefore().toString());
            certJson.put("notAfter", (Object)cert.getNotAfter().toString());
            certJson.put("sigAlgName", (Object)cert.getSigAlgName());
            certJson.put("keySize", (Object)String.valueOf(CertTool.getKeySize(cert)));
            certJson.put("fingerPrint", (Object)CertTool.fingerPrint(bytes));
            return certJson;
        }).asJava()));
        json.put("encryptedAssertionsRequired", this.isEncryptedAssertionsRequired());
        json.put("instantLoginUrlInSession", this.isInstantLoginUrlInSession());
        json.put("usePostBinding", this.isUsePostBinding());
        json.put("metadataURL", (Object)this.getMetadataUrl());
        json.put("singleLogoutServiceURL", (Object)this.getSingleLogoutServiceURL());
        json.put("requestedAuthnContextPolicy", (Object)this.getRequestedAuthnContextPolicy().name());
        json.put("requestedAuthnContextComparison", (Object)this.getRequestedAuthnContextComparison().name());
        json.put("authnContextClassRef", (Object)this.getAuthnContextClassRef());
        json.put("issuerPolicy", (Object)this.getIssuerPolicy().name());
        json.put("issuer", (Object)this.getIssuer());
        json.put("allowCreate", (Object)this.getAllowCreate().name());
        json.put("nameIdFormat", (Object)this.getNameIdFormat().name());
        json.put("customNameIdFormat", (Object)this.getCustomNameIdFormat());
        json.put("sessionIdentificationValidationPolicy", (Object)((SAMLSessionIdentification.ValidationPolicy)Option.of((Object)this.getSessionIdentificationValidationPolicy()).getOrElse((Object)SAMLSessionIdentification.ValidationPolicy.getDefault())).name());
        return json;
    }

    public static enum RequestedAuthnContextPolicy {
        DO_NOT_SEND,
        CUSTOM;

    }

    public static enum RequestedAuthnContextComparison {
        EXACT,
        MINIMUM,
        MAXIMUM,
        BETTER;


        public static List<RequestedAuthnContextComparison> getValues() {
            return Arrays.asList(RequestedAuthnContextComparison.values());
        }
    }

    public static enum IssuerPolicy {
        DEFAULT,
        CUSTOM;

    }
}

