/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.LegacyDiscoverIdpHelper;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;

@UnrestrictedAccess
public class LegacyDiscoverIdpServlet
extends HttpServletFacade {
    private final JsonWrapper jsonWrapper;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private LegacyDiscoverIdpHelper discoverIdpHelper;

    @Inject
    public LegacyDiscoverIdpServlet(JsonWrapper jsonWrapper, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, UserLookupService userLookupService, HostAppFactory hostAppFactory) {
        this.jsonWrapper = jsonWrapper;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = userLookupService;
        this.hostApp = hostAppFactory.getInstance();
    }

    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        resp.setContentType("application/json");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String username = req.getParameter("username");
        boolean isJsmLogin = StringUtils.equals((CharSequence)"true", (CharSequence)req.getParameter("isJsmLogin"));
        this.discoverIdpHelper = new LegacyDiscoverIdpHelper(this.hostApp, this.userLookupService, this.idpConfManager, isJsmLogin);
        Map<String, Object> map = this.getProviderMapForIdentityProviders(username, req);
        map.put("isIdpDisabledUserAgent", this.kerbConfManager.isIdpDisabledUserAgent(req.getHeader("User-Agent")));
        map.put("redirectProgressDelay", 1000 * this.idpConfManager.getRedirectProgressDelay());
        map.putAll(this.getTraditionalLoginValues(username));
        map.put("enableWorkAccount", !this.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP, IdpConfiguration.RedirectPolicy.FALLBACK, IdpConfiguration.RedirectPolicy.ALL)).isEmpty());
        map.put("isAuthenticated", this.hostApp.isLoggedIn(req));
        map.put("kssoAuthAnonymousBrowsingUser", req.getSessionKsso().getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER"));
        map.put("shouldHideUsernameField", this.shouldHideUsernameField(req));
        try {
            this.jsonWrapper.objectWriter().writeValue((Writer)resp.getWriter(), map);
            resp.setStatus(200);
        }
        catch (Exception e) {
            resp.setStatus(204);
        }
    }

    private Map<String, String> getPreviousIdentityProvider(HttpServletRequestFacade req) {
        String loginId = (String)CookieUtil.getPreviouslyKnownLoginId(req).getOrElse((Object)"");
        if (StringUtils.isBlank((CharSequence)loginId)) {
            return new HashMap<String, String>();
        }
        return this.createProviderMap(this.idpConfManager.getEnabledIdentityProviderById(loginId), req);
    }

    private Map<String, Object> getProviderMapForIdentityProviders(String username, HttpServletRequestFacade req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auto", this.getProviderMapForIdentityProviders(this.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.ALL), req));
        map.put("manual", this.getProviderMapForIdentityProviders(this.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP)), req));
        map.put("visible", this.getProviderMapForIdentityProviders(this.discoverIdpHelper.getVisibleProviders(), req));
        if (this.hasPreviouslyKnownLogin(req)) {
            map.put("last", this.getPreviousIdentityProvider(req));
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return map;
        }
        List<IdpConfiguration> matchingManualIdps = this.discoverIdpHelper.discoverManualIdpProviders(username);
        map.put("fallbacks", this.getProviderMapForIdentityProviders(this.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.FALLBACK), req));
        map.put("matches", this.getProviderMapForIdentityProviders(matchingManualIdps, req));
        return map;
    }

    private boolean shouldHideUsernameField(HttpServletRequestFacade req) {
        List<IdpConfiguration> activeIdps = this.discoverIdpHelper.getVisibleProviders();
        for (IdpConfiguration idp : activeIdps) {
            IdpConfiguration.RedirectPolicy redirectPolicy = idp.getRedirectProperties().getRedirectPolicy();
            if (redirectPolicy != IdpConfiguration.RedirectPolicy.USER_DIRECTORY && redirectPolicy != IdpConfiguration.RedirectPolicy.USER_GROUP && redirectPolicy != IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN || this.hasPreviouslyKnownLogin(req)) continue;
            return false;
        }
        return this.kerbConfManager.shouldHideUsernameField();
    }

    private boolean hasPreviouslyKnownLogin(HttpServletRequestFacade req) {
        return (Boolean)CookieUtil.getPreviouslyKnownLoginId(req).map(this.idpConfManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idpConfiguration -> this.discoverIdpHelper.getRedirectProperties((IdpConfiguration)idpConfiguration).isKnownAutoRedirect()).filter(idp -> this.discoverIdpHelper.getRedirectPolicy((IdpConfiguration)idp) != IdpConfiguration.RedirectPolicy.NONE).map(_idp -> true).getOrElse((Object)false);
    }

    private List<Map<String, String>> getProviderMapForIdentityProviders(List<IdpConfiguration> idpConfigurations, HttpServletRequestFacade req) {
        return idpConfigurations.stream().map(idp -> this.createProviderMap((IdpConfiguration)idp, req)).collect(Collectors.toList());
    }

    private Map<String, String> createProviderMap(IdpConfiguration idp, HttpServletRequestFacade req) {
        RedirectProperties redirectProperties = this.discoverIdpHelper.getRedirectProperties(idp);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", idp.getId());
        map.put("name", idp.getName());
        map.put("useHostedDomain", Boolean.valueOf(idp.isHostedDomain()).toString());
        map.put("sendLoginHint", Boolean.valueOf(redirectProperties.isSendLoginHint()).toString());
        map.put("useIcon", Boolean.valueOf(this.idpConfManager.isUseIcon()).toString());
        map.put("pluginAdminPath", "/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
        map.put("kssoPluginKey", this.kerbConfManager.getLicenseManager().getPluginKey());
        map.put("loginUrl", this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()));
        map.put("kind", idp.getKind().toString());
        if (!idp.getKnownDomains().isEmpty()) {
            map.put("hostedDomain", idp.getKnownDomains().stream().findFirst().orElse(""));
        }
        return map;
    }

    private List<IdpConfiguration> getProvidersByRedirectPolicy(EnumSet<IdpConfiguration.RedirectPolicy> redirectPolicies) {
        return this.idpConfManager.getSortedIdentityProviders().stream().filter(idp -> redirectPolicies.contains((Object)this.discoverIdpHelper.getRedirectProperties((IdpConfiguration)idp).getRedirectPolicy())).filter(IdpConfiguration::isEnabled).collect(Collectors.toList());
    }

    private List<IdpConfiguration> getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        return this.getProvidersByRedirectPolicy(EnumSet.of(redirectPolicy));
    }

    private HashMap<String, Object> getTraditionalLoginValues(String username) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowTraditionalLogin", !TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(this.kerbConfManager, this.userLookupService) && this.idpConfManager.isUsernamePasswordLinkEnabled());
        map.put("allowTraditionalLoginJsm", !TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(this.kerbConfManager, this.userLookupService) && this.idpConfManager.isUsernamePasswordLinkEnabled());
        map.put("allTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledMessage());
        map.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            map.put("isUserAllowedToUseTraditionalLogin", TraditionalLoginUtils.isUserAllowedToUseTraditionalLogin(this.kerbConfManager, this.userLookupService, username, this.hostApp));
        }
        return map;
    }
}

