/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.API;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDiscoverIdpHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final IdpConfManager idpConfManager;
    private final boolean isJsmLogin;

    public LegacyDiscoverIdpHelper(HostApp hostApp, UserLookupService userLookupService, IdpConfManager idpConfManager, boolean isJsmLogin) {
        this.hostApp = hostApp;
        this.userLookupService = userLookupService;
        this.idpConfManager = idpConfManager;
        this.isJsmLogin = isJsmLogin;
    }

    RedirectProperties getRedirectProperties(IdpConfiguration idpConfiguration) {
        API.Match.Case[] caseArray = new API.Match.Case[2];
        caseArray[0] = API.Case((API.Match.Pattern0)API.$((Object)true), idpConfiguration::getJsmRedirectProperties);
        caseArray[1] = API.Case((API.Match.Pattern0)API.$((Object)false), idpConfiguration::getRedirectProperties);
        return (RedirectProperties)API.Match((Object)this.isJsmLogin).of(caseArray);
    }

    IdpConfiguration.RedirectPolicy getRedirectPolicy(IdpConfiguration idpConfiguration) {
        return this.getRedirectProperties(idpConfiguration).getRedirectPolicy();
    }

    List<IdpConfiguration> discoverManualIdpProviders(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return Collections.emptyList();
        }
        return Array.ofAll(this.idpConfManager.getSortedIdentityProviders()).filter(IdpConfiguration::isEnabled).filter(configuration -> this.isMatchingConfiguredRedirect(username, (IdpConfiguration)configuration)).flatMap(configuration -> HashMap.of((Object)configuration.getId(), (Object)configuration).values()).asJava();
    }

    boolean isMatchingConfiguredRedirect(String username, IdpConfiguration configuration) {
        switch (this.getRedirectPolicy(configuration)) {
            case KNOWN_DOMAIN: {
                return this.isMatchingKnownDomain(username, configuration);
            }
            case USER_DIRECTORY: {
                return this.isMatchingUserDirectory(username, configuration);
            }
            case USER_GROUP: {
                return this.isMatchingUserGroup(username, configuration);
            }
        }
        return false;
    }

    boolean isMatchingKnownDomain(String maybeUsername, IdpConfiguration configuration) {
        return (Boolean)Option.of((Object)maybeUsername).filter(_username -> this.getRedirectPolicy(configuration) == IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN).map(username -> username.contains("@") ? username.substring(username.indexOf("@") + 1).toLowerCase() : null).map(domain -> this.isMatchingDomain((String)domain, configuration)).getOrElse((Object)false);
    }

    boolean isMatchingUserDirectory(String maybeUsername, IdpConfiguration configuration) {
        RedirectProperties redirectProperties = this.getRedirectProperties(configuration);
        Option<UsernameSearchResult> usernameSearchResults = this.getUsernameSearchResult(maybeUsername, configuration);
        if (usernameSearchResults.isDefined()) {
            String usernameFromSearch = (String)usernameSearchResults.filter(result -> result.getResolvedUserPrincipalEntry() != null).map(UsernameSearchResult::getUserProfile).filter(Objects::nonNull).map(UserProfile::getUsername).getOrElse((Object)maybeUsername);
            return (Boolean)Option.of((Object)usernameFromSearch).filter(_username -> redirectProperties.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_DIRECTORY).map(this.hostApp::getDirectoryForUser).filter(Objects::nonNull).map(directoryForUser -> LegacyDiscoverIdpHelper.isMatchingUserDirectoryRule(directoryForUser, redirectProperties)).getOrElse((Object)this.getRedirectProperties(configuration).isRedirectWhenUserIsNotFound());
        }
        return this.getRedirectProperties(configuration).isRedirectWhenUserIsNotFound();
    }

    private static boolean isMatchingUserDirectoryRule(Directory directoryForUser, RedirectProperties redirectProperties) {
        if (IdpConfiguration.MatchingPolicy.NOT_IN.equals((Object)redirectProperties.getDirectoryMatchingPolicy())) {
            return !redirectProperties.getMatchedUserDirectoryIds().contains(directoryForUser.getId());
        }
        return redirectProperties.getMatchedUserDirectoryIds().contains(directoryForUser.getId());
    }

    boolean isMatchingUserGroup(String maybeUsername, IdpConfiguration configuration) {
        RedirectProperties redirectProperties = this.getRedirectProperties(configuration);
        UsernameSearchResult usernameSearchResult = (UsernameSearchResult)Option.of((Object)maybeUsername).filter(_username -> redirectProperties.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_GROUP).flatMap(username -> this.getUsernameSearchResult((String)username, configuration)).filter(result -> Objects.nonNull(result.getDirectory())).getOrElse((Object)UsernameSearchResult.notFound(null));
        if (usernameSearchResult.isResolved()) {
            return this.isUserHasRequiredGroupsForRedirect(usernameSearchResult, redirectProperties);
        }
        if (usernameSearchResult.isNotFoundWithoutDirectoryCheck()) {
            return this.getRedirectProperties(configuration).isRedirectWhenUserIsNotFound();
        }
        return false;
    }

    private boolean isUserHasRequiredGroupsForRedirect(UsernameSearchResult usernameSearchResult, RedirectProperties redirectProperties) {
        try {
            List userCurrentGroups = this.hostApp.getDirectoryManager().searchNestedGroupRelationships(usernameSearchResult.getDirectory().getId().longValue(), this.getMembershipQuery(usernameSearchResult.getUserProfile().getUsername()));
            return this.isUserMemberOfAtLeastOneGroup(userCurrentGroups, redirectProperties.getRedirectGroups(), redirectProperties.getGroupMatchingPolicy());
        }
        catch (Exception e) {
            this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-9J6JGVLKLD", (String)"Unable to resolve user group memberships while redirecting user to IDP during login."), (Throwable)e);
            return false;
        }
    }

    private boolean isUserMemberOfAtLeastOneGroup(List<String> userCurrentGroups, Set<String> groups, IdpConfiguration.MatchingPolicy groupMatchingPolicy) {
        Array currentGroups = Array.ofAll(userCurrentGroups).distinct().filter(Objects::nonNull);
        if (IdpConfiguration.MatchingPolicy.NOT_IN.equals((Object)groupMatchingPolicy)) {
            return currentGroups.filter(groups::contains).isEmpty();
        }
        return currentGroups.filter(groups::contains).nonEmpty();
    }

    private boolean isMatchingDomain(String domain, IdpConfiguration configuration) {
        return (Boolean)Option.of((Object)domain).filter(_domain -> configuration.isEnabled()).filter(_domain -> this.getRedirectPolicy(configuration) != IdpConfiguration.RedirectPolicy.NONE).filter(Objects::nonNull).map(_domain -> configuration.getKnownDomains().contains(_domain)).getOrElse((Object)false);
    }

    @NotNull
    private Option<UsernameSearchResult> getUsernameSearchResult(String username, IdpConfiguration configuration) {
        Option usernameSearchResults = Option.ofOptional(this.userLookupService.searchUserAccount(username, configuration.getUserNotFoundPolicy(), configuration.getUserLookupAttribute(), false).stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst());
        if (usernameSearchResults.isEmpty() && configuration.getUserLookupAttribute() != IdpConfiguration.UserLookupAttribute.USERNAME) {
            usernameSearchResults = Option.ofOptional(this.userLookupService.searchUserAccount(username, configuration.getUserNotFoundPolicy(), IdpConfiguration.UserLookupAttribute.USERNAME, false).stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst());
        }
        return usernameSearchResults;
    }

    private MembershipQuery<String> getMembershipQuery(String username) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
    }

    List<IdpConfiguration> getVisibleProviders() {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration configuration : this.idpConfManager.getSortedIdentityProviders()) {
            boolean idpVisible;
            boolean bl = idpVisible = this.isJsmLogin ? configuration.getJsmRedirectProperties().isVisible() : configuration.getRedirectProperties().isVisible();
            if (!configuration.isEnabled() || !idpVisible) continue;
            matches.add(configuration);
        }
        return matches;
    }
}

