/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.RedirectUtils;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;

@UnrestrictedAccess
public class DiscoverIdpServlet
extends HttpServletFacade {
    private final JsonWrapper jsonWrapper;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private DiscoverIdpHelper discoverIdpHelper;

    @Inject
    public DiscoverIdpServlet(JsonWrapper jsonWrapper, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, UserLookupService userLookupService, HostAppFactory hostAppFactory) {
        this.jsonWrapper = jsonWrapper;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = userLookupService;
        this.hostApp = hostAppFactory.getInstance();
    }

    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        resp.setContentType("application/json");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String username = req.getParameter("username");
        boolean isJsmLogin = StringUtils.equals((CharSequence)"true", (CharSequence)req.getParameter("isJsmLogin"));
        this.discoverIdpHelper = new DiscoverIdpHelper(this.hostApp, this.userLookupService, this.idpConfManager, isJsmLogin);
        Map<String, Object> map = this.getProviderMapWithUsername(username, req);
        map.put("isIdpDisabledUserAgent", this.kerbConfManager.isIdpDisabledUserAgent(req.getHeader("User-Agent")));
        map.put("redirectProgressDelay", 1000 * this.idpConfManager.getRedirectProgressDelay());
        map.putAll(this.getTraditionalLoginValues(username));
        map.put("enableWorkAccount", !RedirectUtils.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP, IdpConfiguration.RedirectPolicy.FALLBACK, IdpConfiguration.RedirectPolicy.ALL), this.idpConfManager, this.discoverIdpHelper).isEmpty());
        map.put("isAuthenticated", this.hostApp.isLoggedIn(req));
        map.put("kssoAuthAnonymousBrowsingUser", req.getSessionKsso().getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER"));
        map.put("shouldHideUsernameField", RedirectUtils.shouldHideUsernameField(req, this.discoverIdpHelper, this.kerbConfManager, this.idpConfManager));
        try {
            this.jsonWrapper.objectWriter().writeValue((Writer)resp.getWriter(), map);
            resp.setStatus(200);
        }
        catch (Exception e) {
            resp.setStatus(204);
        }
    }

    private Map<String, Object> getProviderMapWithUsername(String username, HttpServletRequestFacade req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : RedirectUtils.getProviderMapForIdentityProviders(req, this.discoverIdpHelper, this.idpConfManager, this.kerbConfManager).entrySet()) {
            if (entry.getKey().endsWith("WithHtml")) {
                map.put(StringUtils.stripEnd((String)entry.getKey(), (String)"WithHtml"), entry.getValue());
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return map;
        }
        List<IdpConfiguration> matchingManualIdps = this.discoverIdpHelper.discoverManualIdpProviders(username);
        map.put("fallbacks", RedirectUtils.getProviderMapForIdentityProviders(RedirectUtils.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.FALLBACK, this.idpConfManager, this.discoverIdpHelper), req, this.discoverIdpHelper, this.idpConfManager, this.kerbConfManager));
        map.put("matches", RedirectUtils.getProviderMapForIdentityProviders(matchingManualIdps, req, this.discoverIdpHelper, this.idpConfManager, this.kerbConfManager));
        return map;
    }

    private HashMap<String, Object> getTraditionalLoginValues(String username) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowTraditionalLogin", !TraditionalLoginUtils.isTraditionalLoginPreventedForAllLicensedUsers(this.kerbConfManager, this.userLookupService) && this.idpConfManager.isUsernamePasswordLinkEnabled());
        map.put("allowTraditionalLoginJsm", !TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(this.kerbConfManager, this.userLookupService) && this.idpConfManager.isUsernamePasswordLinkEnabled());
        map.put("allTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledMessage());
        map.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
        if (StringUtils.isNotBlank((CharSequence)username)) {
            map.put("isUserAllowedToUseTraditionalLogin", TraditionalLoginUtils.isUserAllowedToUseTraditionalLogin(this.kerbConfManager, this.userLookupService, username, this.hostApp));
        }
        return map;
    }
}

