/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.snapshot;

import kantega.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.rest.util.SnapshotRestUtils;

public class SnapshotInfoModel {
    private final String applicationName;
    private final String applicationVersion;
    private final String pluginVersion;
    private final String baseUrl;
    private final long timeMillis;
    private final String description;
    private final String filename;
    private final String id;
    private final boolean readable;

    public SnapshotInfoModel(BackupInfo snapshotInfoCreator) {
        this.applicationName = snapshotInfoCreator.getApplicationName();
        this.applicationVersion = snapshotInfoCreator.getApplicationVersion();
        this.pluginVersion = snapshotInfoCreator.getPluginVersion();
        this.baseUrl = snapshotInfoCreator.getBaseUrl();
        this.timeMillis = snapshotInfoCreator.getTimeMillis();
        this.description = snapshotInfoCreator.getDescription();
        this.filename = snapshotInfoCreator.getFilename();
        this.readable = snapshotInfoCreator.isReadable();
        this.id = SnapshotRestUtils.getIdFromZipFilename(snapshotInfoCreator.getFilename());
    }

    @JsonProperty
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonProperty
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @JsonProperty
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @JsonProperty
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonProperty
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public boolean isReadable() {
        return this.readable;
    }
}

