/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.info;

import com.atlassian.annotations.PublicApi;
import com.kantegasso.cron.CronExpressionHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONObject;

@Path(value="server-time")
@PublicApi
public class ServerTime {
    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, @DefaultValue(value="") @QueryParam(value="cron") String cron) {
        JSONObject json = new JSONObject();
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        if (!StringUtils.equals((CharSequence)"", (CharSequence)cron) && cron != null) {
            CronExpressionHandler generator = CronExpressionHandler.parse((String)cron);
            DateTime next = new DateTime((Object)generator.next(new Date())).toDateTime(DateTimeZone.UTC);
            json.put("dateTimeUTC", (Object)next.toString());
        } else {
            json.put("dateTimeUTC", (Object)DateTime.now().toDateTime(DateTimeZone.UTC).toString());
        }
        return Response.ok((Object)json.toString()).build();
    }
}

