/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.info;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction1;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.ZonedDateTime;
import org.json.JSONObject;
import org.kantega.atlaskerb.rest.util.ResponseUtils;

@Path(value="ping")
@UnrestrictedAccess
@PublicApi
public class PingResource {
    UserManager userManager;

    @Inject
    public PingResource(@ComponentImport UserManager userManager) {
        this.userManager = userManager;
    }

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.user(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            JSONObject json = new JSONObject();
            ZonedDateTime currentTime = ZonedDateTime.now();
            json.put("response", (Object)"pong");
            json.put("timestamp", currentTime.toInstant().toEpochMilli());
            json.put("datetime", (Object)currentTime.toString());
            return Response.ok((Object)json.toString(4)).build();
        });
    }
}

