/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.msteams;

import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.UserAssertion;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsalAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(MsalAuthHelper.class);
    final CacheManager cacheManager;

    @Inject
    public MsalAuthHelper(@ComponentImport CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getOboToken(String scope, String tid, String authToken, String clientId, String secret) throws MalformedURLException, NoSuchAlgorithmException {
        String authority = MessageFormat.format("https://login.microsoftonline.com/{0}", tid);
        ConfidentialClientApplication application = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)clientId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)secret)).authority(authority)).build();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(authToken.getBytes(StandardCharsets.UTF_8));
        String cacheKey = Hex.encodeHexString((byte[])hash);
        String cachedTokens = (String)this.cacheManager.getCache("msgraphtokens").get((Object)cacheKey);
        if (cachedTokens != null) {
            application.tokenCache().deserialize(cachedTokens);
        }
        IAuthenticationResult auth = null;
        OnBehalfOfParameters parameters = OnBehalfOfParameters.builder(Collections.singleton(scope), (UserAssertion)new UserAssertion(authToken)).build();
        try {
            auth = (IAuthenticationResult)application.acquireToken(parameters).join();
            this.cacheManager.getCache("msgraphtokens").put((Object)cacheKey, (Object)application.tokenCache().serialize());
            return auth.accessToken();
        }
        catch (RuntimeException e) {
            log.error("Acquiring token from Entra ID was unsuccessful during Teams login", (Throwable)e);
            return null;
        }
    }
}

