/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.msteams;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsTeamsConfigServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(MsTeamsConfigServlet.class);
    private static final String DISABLE_CLICKJACKING_PROTECTION_PROPERTY = "confluence.clickjacking.protection.disable";
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public MsTeamsConfigServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        response.setContentType("text/html");
        Map<String, Object> model = this.newModel(request);
        model.put("menuItem", "msteams");
        model.put("topMenu", "dark-features");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("msTeamsSecurityHeadersEnabled", this.kerbConfManager.isMsTeamsSecurityHeadersEnabled());
        model.put("msTeamsAuthenticationEnabled", this.kerbConfManager.isMsTeamsAuthenticationEnabled());
        model.put("msTeamsClientId", this.kerbConfManager.getMsTeamsClientId());
        model.put("msTeamsSecret", this.makeStars(this.kerbConfManager.getMsTeamsSecret()));
        model.put("identityProviders", this.idpConfManager.getIdentityProviders());
        model.put("confluenceClickjackingProtectionEnabled", !Boolean.getBoolean(DISABLE_CLICKJACKING_PROTECTION_PROPERTY));
        try {
            this.templateRenderer.render("templates/msteams.vm", model, (Writer)response.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        try {
            String tabName = request.getParameter("tab");
            Object param = "";
            if (StringUtils.isNotBlank((CharSequence)tabName)) {
                param = "?tab=" + tabName;
            }
            if (StringUtils.equals((CharSequence)tabName, (CharSequence)"client-config")) {
                this.kerbConfManager.setMsTeamsClientId(request.getParameter("msTeamsClientId"));
                if (!StringUtils.equals((CharSequence)this.makeStars(this.kerbConfManager.getMsTeamsSecret()), (CharSequence)request.getParameter("msTeamsSecret"))) {
                    this.kerbConfManager.setMsTeamsSecret(request.getParameter("msTeamsSecret"));
                }
                HttpUrlUtils.sendSaveSuccess((HttpServletResponseFacade)response);
            } else if (StringUtils.equals((CharSequence)tabName, (CharSequence)"settings")) {
                this.kerbConfManager.setMsTeamsSecurityHeadersEnabled(request.getParameter("msTeamsSecurityHeadersEnabled") != null);
                this.kerbConfManager.setMsTeamsAuthenticationEnabled(request.getParameter("msTeamsAuthenticationEnabled") != null);
                HttpUrlUtils.sendSaveSuccess((HttpServletResponseFacade)response);
            } else {
                HttpUrlUtils.sendSaveError((HttpServletResponseFacade)response, null);
                log.error("Problem saving Teams settings");
            }
        }
        catch (Exception e) {
            HttpUrlUtils.sendSaveError((HttpServletResponseFacade)response, (Exception)e);
            log.error("Problem saving Teams settings", (Throwable)e);
        }
    }

    private String makeStars(String secret) {
        StringBuilder stars = new StringBuilder();
        if (secret != null) {
            for (int i = 0; i < secret.length(); ++i) {
                stars.append("*");
            }
        }
        return stars.toString();
    }
}

