/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.kantega.atlaskerb.KerbConfManager;

@UnrestrictedAccess
public class KerberosScmFilter
extends FilterFacade {
    private final KerbConfManager kerbConfManager;

    @Inject
    public KerberosScmFilter(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        if (this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled()) {
            String requestURI = request.getRequestURI().substring(request.getContextPath().length()).substring("/kerberos-scm".length());
            try {
                request.getRequestDispatcher("/scm" + requestURI).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            chain.doFilterKsso(request, response);
        }
    }

    public void destroy() {
    }
}

